/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.IBrowserHistory;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.Utf8ResourceBundle;
import org.eclipse.rap.rwt.internal.application.RWTFactory;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.internal.widgets.BrowserHistory;
import org.eclipse.rap.rwt.lifecycle.ILifeCycle;
import org.eclipse.rap.rwt.resources.IResourceManager;
import org.eclipse.rap.rwt.service.IApplicationStore;
import org.eclipse.rap.rwt.service.IServiceManager;
import org.eclipse.rap.rwt.service.IServiceStore;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.rap.rwt.service.ISettingStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public final class RWT {
    private static final String LOCALE = String.valueOf(RWT.class.getName()) + ".LOCALE";
    public static final String ACTIVE_KEYS = "org.eclipse.rap.rwt.activeKeys";
    public static final String CANCEL_KEYS = "org.eclipse.rap.rwt.cancelKeys";
    public static final String CUSTOM_ITEM_HEIGHT = "org.eclipse.rap.rwt.customItemHeight";
    public static final String MARKUP_ENABLED = "org.eclipse.rap.rwt.markupEnabled";
    public static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    public static final String DEFAULT_THEME_ID = "org.eclipse.rap.rwt.theme.Default";
    public static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";

    public static ILifeCycle getLifeCycle() {
        return RWTFactory.getLifeCycleFactory().getLifeCycle();
    }

    public static IResourceManager getResourceManager() {
        return RWTFactory.getResourceManager();
    }

    public static IServiceManager getServiceManager() {
        return RWTFactory.getServiceManager();
    }

    public static ISettingStore getSettingStore() {
        return RWTFactory.getSettingStoreManager().getStore();
    }

    public static IServiceStore getServiceStore() {
        RWT.checkHasPhase();
        return ContextProvider.getServiceStore();
    }

    public static ISessionStore getSessionStore() {
        return ContextProvider.getSessionStore();
    }

    public static IApplicationStore getApplicationStore() {
        return RWTFactory.getApplicationStore();
    }

    public static HttpServletRequest getRequest() {
        RWT.checkHasSessionContext();
        return ContextProvider.getRequest();
    }

    public static HttpServletResponse getResponse() {
        RWT.checkHasSessionContext();
        return ContextProvider.getResponse();
    }

    public static Locale getLocale() {
        RWT.checkHasSessionContext();
        Locale result = (Locale)ContextProvider.getSessionStore().getAttribute(LOCALE);
        if (result == null) {
            result = ContextProvider.getRequest().getLocale();
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        return result;
    }

    public static void setLocale(Locale locale) {
        RWT.checkHasSessionContext();
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        sessionStore.setAttribute(LOCALE, locale);
    }

    public static IBrowserHistory getBrowserHistory() {
        return SingletonUtil.getSessionInstance(BrowserHistory.class);
    }

    public static void requestThreadExec(Runnable runnable) {
        ParamCheck.notNull(runnable, "runnable");
        RWT.checkHasPhase();
        Display display = LifeCycleUtil.getSessionDisplay();
        if (display == null || display.isDisposed()) {
            SWT.error(45);
        }
        LifeCycle lifeCycle = (LifeCycle)RWT.getLifeCycle();
        lifeCycle.requestThreadExec(runnable);
    }

    private static void checkHasSessionContext() {
        if (!ContextProvider.hasContext()) {
            SWT.error(22);
        }
    }

    private static void checkHasPhase() {
        if (!ContextProvider.hasContext() || CurrentPhase.get() == null) {
            SWT.error(22);
        }
    }

    private RWT() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NLS {
        private static final Map<ResourceBundle, Object> map = new HashMap<ResourceBundle, Object>();

        public static Object getISO8859_1Encoded(String bundleName, Class<?> clazz) {
            ClassLoader loader = clazz.getClassLoader();
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, RWT.getLocale(), loader);
            return NLS.internalGet(bundle, clazz);
        }

        public static Object getUTF8Encoded(String bundleName, Class<?> clazz) {
            ClassLoader loader = clazz.getClassLoader();
            ResourceBundle bundle = Utf8ResourceBundle.getBundle(bundleName, RWT.getLocale(), loader);
            return NLS.internalGet(bundle, clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object internalGet(ResourceBundle bundle, Class<?> clazz) {
            Object result;
            Map<ResourceBundle, Object> map = NLS.map;
            synchronized (map) {
                result = NLS.map.get(bundle);
                if (result == null) {
                    result = ClassUtil.newInstance(clazz);
                    Field[] fields = clazz.getDeclaredFields();
                    int i = 0;
                    while (i < fields.length) {
                        block10: {
                            String fieldName = fields[i].getName();
                            try {
                                if (!String.class.isAssignableFrom(fields[i].getType()) || !Modifier.isPublic(fields[i].getModifiers()) || Modifier.isStatic(fields[i].getModifiers())) break block10;
                                try {
                                    String value = bundle.getString(fieldName);
                                    if (value != null) {
                                        fields[i].setAccessible(true);
                                        fields[i].set(result, value);
                                    }
                                }
                                catch (MissingResourceException mre) {
                                    fields[i].setAccessible(true);
                                    fields[i].set(result, "");
                                    throw mre;
                                }
                            }
                            catch (Exception ex) {
                                String qualifiedName = String.valueOf(clazz.getName()) + "#" + fieldName;
                                ServletLog.log("Failed to load localized message for: " + qualifiedName, ex);
                            }
                        }
                        ++i;
                    }
                    NLS.map.put(bundle, result);
                }
            }
            return result;
        }
    }
}

