/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rap.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rap.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.swt.widgets.Widget;

public final class ThemeAdapterManager {
    private final Map<Class, IThemeAdapter> themeAdapters = new HashMap<Class, IThemeAdapter>();

    public void reset() {
        this.themeAdapters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThemeAdapter getThemeAdapter(Widget widget) {
        IThemeAdapter result;
        Class<?> widgetClass = widget.getClass();
        Map<Class, IThemeAdapter> map = this.themeAdapters;
        synchronized (map) {
            result = this.themeAdapters.get(widgetClass);
            if (result == null) {
                IThemeAdapter adapter = ThemeAdapterManager.findThemeAdapter(widgetClass);
                this.themeAdapters.put(widgetClass, adapter);
                result = adapter;
            }
        }
        ThemeAdapterManager.ensureThemeAdapterWasFound(widgetClass, result);
        return result;
    }

    private static IThemeAdapter findThemeAdapter(Class widgetClass) {
        IThemeAdapter result = null;
        Class superClass = widgetClass;
        while (!Object.class.equals((Object)superClass) && result == null) {
            result = ThemeAdapterManager.loadThemeAdapter(superClass);
            if (result != null) continue;
            superClass = superClass.getSuperclass();
        }
        return result;
    }

    private static IThemeAdapter loadThemeAdapter(Class clazz) {
        IThemeAdapter result = null;
        String className = LifeCycleAdapterUtil.getSimpleClassName(clazz);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(clazz);
        int i = 0;
        while (result == null && i < variants.length) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(variants[i]);
            buffer.append(".");
            buffer.append(className);
            buffer.append("ThemeAdapter");
            String classToLoad = buffer.toString();
            ClassLoader loader = clazz.getClassLoader();
            result = ThemeAdapterManager.loadThemeAdapter(classToLoad, loader);
            ++i;
        }
        return result;
    }

    private static IThemeAdapter loadThemeAdapter(String className, ClassLoader classLoader) {
        IThemeAdapter result = null;
        try {
            result = (IThemeAdapter)ClassUtil.newInstance(classLoader, className);
        }
        catch (ClassInstantiationException classInstantiationException) {}
        return result;
    }

    private static void ensureThemeAdapterWasFound(Class widgetClass, IThemeAdapter result) {
        if (result == null) {
            String msg = "Failed to obtain theme adapter for class: " + widgetClass.getName();
            throw new ThemeManagerException(msg);
        }
    }
}

