/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (effect instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)effect;
        }
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DropTargetEvent.addListener(this, listener);
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = DropTarget.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        return (DropTargetListener[])DropTargetEvent.getListeners(this);
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DropTargetEvent.removeListener(this, listener);
    }

    public void setDropTargetEffect(DropTargetEffect effect) {
        this.dropEffect = effect;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
    }
}

