/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.events;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.service.IServiceStore;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedEvent
extends org.eclipse.rap.rwt.internal.events.Event {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_SCHEDULED_EVENT_LIST = String.valueOf(TypedEvent.class.getName()) + "#scheduledEventList";
    private static final int[] EVENT_ORDER = new int[]{10, 11, 27, 26, 21, 23, 22, 12, 36, 16, 15, 31, 1, 17, 18, 25, 24, 3, 8, 35, 5031, 5032, 5033, 5034, 5035, 5001, 13, 14, 4, 28, 2, 29, 2008, 2000, 2001, 2002, 2004, 2003, 2007, 2006, 2005, 5011, 5012, 5021, 5022, 30, 9};
    private Event sourceEvent;
    public Display display;
    public Widget widget;
    public Object data;

    public TypedEvent(Event e) {
        super(e.widget, e.type);
        this.display = e.display;
        this.widget = e.widget;
        this.data = e.data;
        this.sourceEvent = e;
    }

    public TypedEvent(Object source) {
        this(source, 0);
    }

    public TypedEvent(Object source, int id) {
        super(source, id);
        this.widget = (Widget)source;
        this.display = this.widget.getDisplay();
    }

    @Override
    public Object getSource() {
        return super.getSource();
    }

    @Override
    public final void processEvent() {
        PhaseId currentPhase = CurrentPhase.get();
        if (currentPhase != null) {
            if (PhaseId.PREPARE_UI_ROOT.equals(currentPhase) || PhaseId.PROCESS_ACTION.equals(currentPhase)) {
                if (!TypedEvent.isFiltered(this.processFilters())) {
                    super.processEvent();
                }
            } else {
                TypedEvent.addToScheduledEvents(this);
            }
        }
    }

    public static boolean executeNext() {
        boolean result = false;
        TypedEvent[] events = TypedEvent.getScheduledEvents();
        while (!result && events.length > 0) {
            TypedEvent event = events[0];
            TypedEvent.getScheduledEventList().remove(event);
            if (event.allowProcessing()) {
                event.processEvent();
                result = true;
            }
            events = TypedEvent.getScheduledEvents();
        }
        return result;
    }

    private Event processFilters() {
        IDisplayAdapter.IFilterEntry[] filters = this.getFilterEntries();
        Event result = new Event();
        if (this.sourceEvent != null) {
            this.copyFields(this.sourceEvent, result);
        }
        result.display = this.display;
        result.widget = this.widget;
        result.type = this.getID();
        int i = 0;
        while (!TypedEvent.isFiltered(result) && i < filters.length) {
            if (filters[i].getType() == result.type) {
                filters[i].getListener().handleEvent(result);
            }
            ++i;
        }
        return result;
    }

    private void copyFields(Event from, Event to) {
        to.button = from.button;
        to.character = from.character;
        to.count = from.count;
        to.data = from.data;
        to.detail = from.detail;
        to.display = from.display;
        to.doit = from.doit;
        to.end = from.end;
        to.height = from.height;
        to.index = from.index;
        to.item = from.item;
        to.keyCode = from.keyCode;
        to.start = from.start;
        to.stateMask = from.stateMask;
        to.text = from.text;
        to.type = from.type;
        to.widget = from.widget;
        to.width = from.width;
        to.x = from.x;
        to.y = from.y;
    }

    private static boolean isFiltered(Event event) {
        return event.type == 0;
    }

    private IDisplayAdapter.IFilterEntry[] getFilterEntries() {
        Display display = this.widget.getDisplay();
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter.getFilters();
    }

    private static void addToScheduledEvents(TypedEvent event) {
        TypedEvent.getScheduledEventList().add(event);
    }

    private static TypedEvent[] getScheduledEvents() {
        List<TypedEvent> list = TypedEvent.getScheduledEventList();
        ArrayList<TypedEvent> sortedEvents = new ArrayList<TypedEvent>();
        int i = 0;
        while (i < EVENT_ORDER.length) {
            int k = 0;
            while (k < list.size()) {
                TypedEvent event = list.get(k);
                if (EVENT_ORDER[i] == event.getID()) {
                    sortedEvents.add(event);
                }
                ++k;
            }
            ++i;
        }
        TypedEvent[] result = new TypedEvent[sortedEvents.size()];
        sortedEvents.toArray(result);
        return result;
    }

    private static List<TypedEvent> getScheduledEventList() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        ArrayList result = (ArrayList)serviceStore.getAttribute(ATTR_SCHEDULED_EVENT_LIST);
        if (result == null) {
            result = new ArrayList();
            serviceStore.setAttribute(ATTR_SCHEDULED_EVENT_LIST, result);
        }
        return result;
    }

    protected boolean allowProcessing() {
        String msg = "Derived classes must override allowProcessing.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    protected void dispatchToObserver(Object listener) {
        String msg = "Derived classes must override dispatchToObserver.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    protected Class getListenerType() {
        String msg = "Derived classes must override getListenerType.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + "{" + this.widget + " data=" + this.data + "}";
    }

    private String getName() {
        String result = this.getClass().getName();
        int index = result.lastIndexOf(46);
        if (index != -1) {
            result = result.substring(index + 1, result.length());
        }
        return result;
    }
}

