/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IToolItemAdapter;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class ToolItemLCAUtil {
    private static final String TYPE = "rwt.widgets.ToolItem";
    private static final String[] ALLOWED_STYLES = new String[]{"PUSH", "CHECK", "RADIO", "SEPARATOR", "DROP_DOWN"};
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_HOT_IMAGE = "hotImage";
    private static final String PROP_CONTROL = "control";
    static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_LISTENER = "selection";

    private ToolItemLCAUtil() {
    }

    static void preserveValues(ToolItem toolItem) {
        WidgetLCAUtil.preserveBounds(toolItem, toolItem.getBounds());
        WidgetLCAUtil.preserveEnabled(toolItem, toolItem.getEnabled());
        WidgetLCAUtil.preserveToolTipText(toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.preserveCustomVariant(toolItem);
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_VISIBLE, ToolItemLCAUtil.isVisible(toolItem));
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_TEXT, toolItem.getText());
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_IMAGE, ToolItemLCAUtil.getImage(toolItem));
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_HOT_IMAGE, toolItem.getHotImage());
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_CONTROL, toolItem.getControl());
        WidgetLCAUtil.preserveProperty((Widget)toolItem, "selection", toolItem.getSelection());
        WidgetLCAUtil.preserveListener(toolItem, "selection", SelectionEvent.hasListener(toolItem));
    }

    static void renderInitialization(ToolItem toolItem) {
        ToolBar toolBar = toolItem.getParent();
        IClientObject clientObject = ClientObjectFactory.getClientObject(toolItem);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(toolItem.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(toolItem, ALLOWED_STYLES));
        clientObject.set("index", toolBar.indexOf(toolItem));
    }

    static void renderChanges(ToolItem toolItem) {
        WidgetLCAUtil.renderBounds(toolItem, toolItem.getBounds());
        WidgetLCAUtil.renderEnabled(toolItem, toolItem.getEnabled());
        WidgetLCAUtil.renderToolTip(toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.renderCustomVariant(toolItem);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_VISIBLE, ToolItemLCAUtil.isVisible(toolItem), true);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_TEXT, toolItem.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_IMAGE, ToolItemLCAUtil.getImage(toolItem), null);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_HOT_IMAGE, toolItem.getHotImage(), null);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_CONTROL, toolItem.getControl(), null);
        WidgetLCAUtil.renderProperty((Widget)toolItem, "selection", toolItem.getSelection(), false);
        WidgetLCAUtil.renderListener(toolItem, "selection", SelectionEvent.hasListener(toolItem), false);
    }

    static void processSelection(ToolItem toolItem) {
        if (WidgetLCAUtil.wasEventSent(toolItem, "org.eclipse.swt.events.widgetSelected")) {
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            SelectionEvent event = new SelectionEvent(toolItem, null, 13, bounds, stateMask, null, true, 0);
            event.processEvent();
        }
    }

    private static boolean isVisible(ToolItem toolItem) {
        IToolItemAdapter adapter;
        IToolItemAdapter toolItemAdapter = adapter = toolItem.getAdapter(IToolItemAdapter.class);
        return toolItemAdapter.getVisible();
    }

    static Image getImage(ToolItem toolItem) {
        Image result;
        if (toolItem.getEnabled() && toolItem.getParent().getEnabled()) {
            result = toolItem.getImage();
        } else {
            result = toolItem.getDisabledImage();
            if (result == null) {
                result = toolItem.getImage();
            }
        }
        return result;
    }
}

