/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.coordinator;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.coordinator.CoordinationPermission;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CoordinationPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private Map<String, CoordinationPermission> permissions = new HashMap<String, CoordinationPermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.HashMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("permissions", clazz);
        objectStreamFieldArray[1] = new ObjectStreamField("all_allowed", Boolean.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof CoordinationPermission)) {
            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(permission).toString());
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        CoordinationPermission cp = (CoordinationPermission)permission;
        if (cp.bundle != null) {
            throw new IllegalArgumentException(new StringBuffer("cannot add to collection: ").append(cp).toString());
        }
        String name = cp.getName();
        CoordinationPermissionCollection coordinationPermissionCollection = this;
        synchronized (coordinationPermissionCollection) {
            Map<String, CoordinationPermission> pc = this.permissions;
            CoordinationPermission existing = pc.get(name);
            if (existing != null) {
                int oldMask = existing.action_mask;
                int newMask = cp.action_mask;
                if (oldMask != newMask) {
                    pc.put(name, new CoordinationPermission(existing.filter, oldMask | newMask));
                }
            } else {
                pc.put(name, cp);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<CoordinationPermission> perms;
        if (!(permission instanceof CoordinationPermission)) {
            return false;
        }
        CoordinationPermission requested = (CoordinationPermission)permission;
        if (requested.filter != null) {
            return false;
        }
        int effective = 0;
        CoordinationPermissionCollection coordinationPermissionCollection = this;
        synchronized (coordinationPermissionCollection) {
            Map<String, CoordinationPermission> pc;
            block7: {
                int desired;
                CoordinationPermission cp;
                pc = this.permissions;
                if (!this.all_allowed || (cp = pc.get("*")) == null || ((effective |= cp.action_mask) & (desired = requested.action_mask)) != desired) break block7;
                return true;
            }
            perms = pc.values();
        }
        for (CoordinationPermission perm : perms) {
            if (!perm.implies0(requested, effective)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<CoordinationPermission> all = new ArrayList<CoordinationPermission>(this.permissions.values());
        return Collections.enumeration(all);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", this.permissions);
        pfields.put("all_allowed", this.all_allowed);
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        this.permissions = (HashMap)gfields.get("permissions", null);
        this.all_allowed = gfields.get("all_allowed", false);
    }
}

