/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.httpdeployer.internal;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.rtp.core.RuntimeProvisioningService;
import org.eclipse.rtp.httpdeployer.bundle.BundleServlet;
import org.eclipse.rtp.httpdeployer.feature.FeatureManager;
import org.eclipse.rtp.httpdeployer.feature.FeatureServlet;
import org.eclipse.rtp.httpdeployer.internal.SystemServlet;
import org.eclipse.rtp.httpdeployer.repository.RepositoryManager;
import org.eclipse.rtp.httpdeployer.repository.RepositoryServlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpDeployerInitializer {
    public static final String ALIAS_BUNDLE = "/bundle";
    public static final String ALIAS_REPOSITORY = "/repository";
    public static final String ALIAS_FEATURE = "/feature";
    public static final String ALIAS_SYSTEM = "/system";
    private HttpService httpService;
    private BundleServlet bundleServlet;
    private RepositoryServlet repositoryServlet;
    private FeatureServlet featureServlet;
    private SystemServlet systemServlet;
    private RepositoryManager repositoryManager;
    private FeatureManager featureManager;
    private RuntimeProvisioningService rtpService;

    public void init() throws ServletException, NamespaceException {
        this.createManager();
        this.createServlets();
        this.registerServlets();
    }

    private void createManager() {
        this.repositoryManager = new RepositoryManager(this.rtpService);
        this.featureManager = new FeatureManager(this.rtpService);
    }

    private void createServlets() {
        this.bundleServlet = new BundleServlet();
        this.repositoryServlet = new RepositoryServlet(this.repositoryManager);
        this.featureServlet = new FeatureServlet(this.featureManager, this.repositoryManager);
        this.systemServlet = new SystemServlet();
    }

    private void registerServlets() throws ServletException, NamespaceException {
        this.httpService.registerServlet(ALIAS_BUNDLE, (Servlet)this.bundleServlet, null, null);
        this.httpService.registerServlet(ALIAS_REPOSITORY, (Servlet)this.repositoryServlet, null, null);
        this.httpService.registerServlet(ALIAS_FEATURE, (Servlet)this.featureServlet, null, null);
        this.httpService.registerServlet(ALIAS_SYSTEM, (Servlet)this.systemServlet, null, null);
    }

    public void setRtpService(RuntimeProvisioningService rtpService) {
        this.rtpService = rtpService;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unregister() {
        this.httpService.unregister(ALIAS_BUNDLE);
        this.httpService.unregister(ALIAS_REPOSITORY);
        this.httpService.unregister(ALIAS_FEATURE);
        this.httpService.unregister(ALIAS_SYSTEM);
    }
}

