/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.application;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRunner {
    public static final String RESOURCES = "rwt-resources";
    private final ApplicationContext applicationContext;

    public ApplicationRunner(ApplicationConfiguration configuration, ServletContext servletContext) {
        ParamCheck.notNull(configuration, "configuration");
        ParamCheck.notNull(servletContext, "servletContext");
        this.applicationContext = new ApplicationContext(configuration, servletContext);
    }

    public void start() {
        ApplicationContextUtil.set(this.applicationContext.getServletContext(), this.applicationContext);
        this.activateApplicationContext();
    }

    public void stop() {
        try {
            if (this.applicationContext.isActive()) {
                this.applicationContext.deactivate();
            }
        }
        finally {
            ApplicationContextUtil.remove(this.applicationContext.getServletContext());
        }
    }

    @Deprecated
    public Collection<String> getServletPaths() {
        HashSet<String> result = new HashSet<String>();
        Collection<String> servletPaths = this.applicationContext.getEntryPointManager().getServletPaths();
        result.addAll(servletPaths);
        return Collections.unmodifiableCollection(result);
    }

    private void activateApplicationContext() {
        try {
            this.applicationContext.activate();
        }
        catch (RuntimeException rte) {
            ApplicationContextUtil.remove(this.applicationContext.getServletContext());
            throw rte;
        }
    }
}

