/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.FakeContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Display;

final class UIThread
extends Thread
implements IUIThreadHolder,
ISessionShutdownAdapter {
    private ServiceContext serviceContext;
    private ISessionStore sessionStore;
    private Runnable shutdownCallback;
    private volatile boolean uiThreadTerminating;

    public UIThread(Runnable runnable) {
        super(runnable);
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void updateServiceContext() {
        if (ContextProvider.hasContext()) {
            ContextProvider.releaseContextHolder();
        }
        ContextProvider.setContext(this.serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchThread() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.checkAndReportTerminatedUIThread();
            lock.notifyAll();
            boolean done = false;
            while (!done) {
                try {
                    lock.wait();
                    done = true;
                }
                catch (InterruptedException e) {
                    this.handleInterruptInSwitchThread(e);
                }
            }
        }
    }

    private void checkAndReportTerminatedUIThread() {
        if (!this.getThread().isAlive()) {
            String msg = "Thread '" + Thread.currentThread() + "' is waiting for already terminated UIThread";
            ServletLog.log("", new RuntimeException(msg));
        }
    }

    private void handleInterruptInSwitchThread(InterruptedException e) throws UIThreadTerminatedError {
        Thread.interrupted();
        if (this.uiThreadTerminating) {
            this.updateServiceContext();
            CurrentPhase.set(PhaseId.PROCESS_ACTION);
            this.uiThreadTerminating = false;
            throw new UIThreadTerminatedError();
        }
        if (Thread.currentThread() != this.getThread()) {
            String msg = "Received InterruptedException on request thread";
            ServletLog.log(msg, e);
        }
    }

    public void run() {
        super.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateThread() {
        ServiceContext serviceContext = FakeContextUtil.createFakeContext(this.sessionStore);
        this.setServiceContext(serviceContext);
        this.uiThreadTerminating = true;
        Object object = this.getLock();
        synchronized (object) {
            this.getThread().interrupt();
        }
        try {
            this.getThread().join();
        }
        catch (InterruptedException e) {
            String msg = "Received InterruptedException while terminating UIThread";
            ServletLog.log(msg, e);
        }
        this.uiThreadTerminating = false;
    }

    public Thread getThread() {
        return this;
    }

    public Object getLock() {
        return this;
    }

    public void setSessionStore(ISessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public void setShutdownCallback(Runnable shutdownCallback) {
        this.shutdownCallback = shutdownCallback;
    }

    public void interceptShutdown() {
        this.terminateThread();
    }

    public void processShutdown() {
        this.updateServiceContext();
        try {
            CurrentPhase.set(PhaseId.PROCESS_ACTION);
            Display display = LifeCycleUtil.getSessionDisplay(this.sessionStore);
            if (this.isApplicationContextActive() && display != null) {
                display.dispose();
            }
            this.shutdownCallback.run();
        }
        finally {
            ContextProvider.disposeContext();
        }
    }

    private boolean isApplicationContextActive() {
        ApplicationContext applicationContext = ApplicationContextUtil.get(this.sessionStore);
        return applicationContext != null && applicationContext.isActive();
    }

    static final class UIThreadTerminatedError
    extends ThreadDeath {
        private static final long serialVersionUID = 1L;

        UIThreadTerminatedError() {
        }
    }
}

