/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.File;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

public class ResourceDirectory {
    public static final String DIRNAME = "rwt-resources";
    private File resourcesDir;

    public void configure(String contextDirectory) {
        ParamCheck.notNull(contextDirectory, "contextDirectory");
        this.resourcesDir = new File(contextDirectory, DIRNAME);
    }

    public void reset() {
        this.resourcesDir = null;
    }

    public void createDirectory() {
        if (!this.resourcesDir.exists()) {
            this.resourcesDir.mkdirs();
        }
    }

    public void deleteDirectory() {
        ApplicationContextUtil.delete(this.resourcesDir);
    }

    public File getDirectory() {
        if (this.resourcesDir == null) {
            throw new IllegalStateException("Resources directory not configured");
        }
        return this.resourcesDir;
    }
}

