/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.ValueSelector;
import org.eclipse.rap.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Widget;

public final class WidgetMatcher
implements ValueSelector {
    private final Map<String, Constraint> constraintMap = new HashMap<String, Constraint>();

    public void addStyle(String string, int style) {
        this.constraintMap.put("[" + string, WidgetMatcher.createStyleConstraint(style));
    }

    public void addState(String string, Constraint constraint) {
        this.constraintMap.put(":" + string, constraint);
    }

    public QxType select(ConditionalValue[] values, Widget widget) {
        QxType result = null;
        int i = 0;
        while (i < values.length && result == null) {
            ConditionalValue condValue = values[i];
            String[] constraints = condValue.constraints;
            if (this.matches(widget, constraints)) {
                result = condValue.value;
            }
            ++i;
        }
        return result;
    }

    public static Constraint createStyleConstraint(final int style) {
        Constraint matcher = new Constraint(){

            public boolean matches(Widget widget) {
                return (widget.getStyle() & style) != 0;
            }
        };
        return matcher;
    }

    private boolean matches(Widget widget, String[] constraints) {
        boolean result = true;
        int i = 0;
        while (i < constraints.length && result) {
            String string = constraints[i];
            if (string.startsWith(".")) {
                String variant = string.substring(1);
                result &= WidgetMatcher.hasVariant(widget, variant);
            } else {
                Constraint constraint = this.constraintMap.get(string);
                result &= constraint != null && constraint.matches(widget);
            }
            ++i;
        }
        return result;
    }

    private static boolean hasVariant(Widget widget, String variant) {
        String actualVariant = WidgetUtil.getVariant(widget);
        return actualVariant != null && actualVariant.equals(variant);
    }

    public static interface Constraint {
        public boolean matches(Widget var1);
    }
}

