/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.clabelkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.clabelkit.CLabelThemeAdapter;
import org.eclipse.swt.widgets.Widget;

public final class CLabelLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Label";
    private static final String[] ALLOWED_STYLES = new String[]{"SHADOW_IN", "SHADOW_OUT", "SHADOW_NONE", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_LEFT_MARGIN = "leftMargin";
    private static final String PROP_TOP_MARGIN = "topMargin";
    private static final String PROP_RIGHT_MARGIN = "rightMargin";
    private static final String PROP_BOTTOM_MARGIN = "bottomMargin";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String DEFAULT_ALIGNMENT = "left";

    public void preserveValues(Widget widget) {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.preserveValues(label);
        WidgetLCAUtil.preserveCustomVariant(label);
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_TEXT, label.getText());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_IMAGE, label.getImage());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_ALIGNMENT, CLabelLCA.getAlignment(label));
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_LEFT_MARGIN, label.getLeftMargin());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_TOP_MARGIN, label.getTopMargin());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_RIGHT_MARGIN, label.getRightMargin());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_BOTTOM_MARGIN, label.getBottomMargin());
        WidgetLCAUtil.preserveBackgroundGradient(label);
    }

    public void readData(Widget widget) {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.processEvents(label);
        ControlLCAUtil.processKeyEvents(label);
        ControlLCAUtil.processMenuDetect(label);
        WidgetLCAUtil.processHelp(label);
    }

    public void renderInitialization(Widget widget) throws IOException {
        CLabel clabel = (CLabel)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(clabel);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(clabel.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(clabel, ALLOWED_STYLES));
        clientObject.set("appearance", "clabel");
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_MARKUP_ENABLED, CLabelLCA.isMarkupEnabled(clabel), false);
    }

    public void renderChanges(Widget widget) throws IOException {
        CLabel clabel = (CLabel)widget;
        ControlLCAUtil.renderChanges(clabel);
        WidgetLCAUtil.renderCustomVariant(clabel);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_TEXT, clabel.getText(), null);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_IMAGE, clabel.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_ALIGNMENT, CLabelLCA.getAlignment(clabel), DEFAULT_ALIGNMENT);
        CLabelLCA.renderMargins(clabel);
        WidgetLCAUtil.renderBackgroundGradient(clabel);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void renderMargins(CLabel clabel) {
        Rectangle padding = CLabelLCA.getThemeAdapter(clabel).getPadding(clabel);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_LEFT_MARGIN, clabel.getLeftMargin(), padding.x);
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_TOP_MARGIN, clabel.getTopMargin(), padding.y);
        int defRightMargin = padding.width - padding.x;
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_RIGHT_MARGIN, clabel.getRightMargin(), defRightMargin);
        int defBottomMargin = padding.height - padding.y;
        WidgetLCAUtil.renderProperty((Widget)clabel, PROP_BOTTOM_MARGIN, clabel.getBottomMargin(), defBottomMargin);
    }

    private static boolean isMarkupEnabled(CLabel clabel) {
        return Boolean.TRUE.equals(clabel.getData("org.eclipse.rap.rwt.markupEnabled"));
    }

    private static String getAlignment(CLabel clabel) {
        int alignment = clabel.getAlignment();
        String result = (alignment & 0x4000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : DEFAULT_ALIGNMENT));
        return result;
    }

    private static CLabelThemeAdapter getThemeAdapter(CLabel clabel) {
        IThemeAdapter adapter = clabel.getAdapter(IThemeAdapter.class);
        return (CLabelThemeAdapter)adapter;
    }
}

