/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.coolitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ICoolBarAdapter;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Widget;

public class CoolItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.CoolItem";
    private static final String[] ALLOWED_STYLES = new String[]{"DROP_DOWN", "VERTICAL"};
    static final String PROP_CONTROL = "control";

    public void preserveValues(Widget widget) {
        CoolItem coolItem = (CoolItem)widget;
        IWidgetAdapter adapter = WidgetUtil.getAdapter(coolItem);
        adapter.preserve(PROP_CONTROL, coolItem.getControl());
        adapter.preserve("bounds", coolItem.getBounds());
        WidgetLCAUtil.preserveCustomVariant(coolItem);
    }

    public void readData(Widget widget) {
        final CoolItem coolItem = (CoolItem)widget;
        String methodName = "move";
        if (ProtocolUtil.wasCallSend(WidgetUtil.getId(coolItem), methodName)) {
            String left = ProtocolUtil.readCallPropertyValueAsString(WidgetUtil.getId(coolItem), methodName, "left");
            final int newLeft = NumberFormatUtil.parseInt(left);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    CoolItemLCA.moveItem(coolItem, newLeft);
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        CoolItem item = (CoolItem)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(item);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(item.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(item, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        CoolItem item = (CoolItem)widget;
        WidgetLCAUtil.renderBounds(item, item.getBounds());
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CONTROL, item.getControl(), null);
        WidgetLCAUtil.renderCustomVariant(item);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void moveItem(CoolItem coolItem, int newX) {
        CoolItem[] items = coolItem.getParent().getItems();
        boolean changed = false;
        int newOrder = -1;
        int maxX = 0;
        int minX = 0;
        int i = 0;
        while (newOrder == -1 && i < items.length) {
            CoolItem item = items[i];
            Rectangle itemBounds = item.getBounds();
            if (item != coolItem && itemBounds.contains(newX, itemBounds.y)) {
                newOrder = coolItem.getBounds().x > newX ? i + 1 : i;
                changed = CoolItemLCA.changeOrder(coolItem, newOrder);
            }
            maxX = Math.max(maxX, itemBounds.x + itemBounds.width);
            minX = Math.min(minX, itemBounds.x);
            ++i;
        }
        if (newOrder == -1 && newX > maxX) {
            int last = coolItem.getParent().getItemCount() - 1;
            changed = CoolItemLCA.changeOrder(coolItem, last);
        } else if (newOrder == -1 && newX < minX) {
            changed = CoolItemLCA.changeOrder(coolItem, 0);
        }
        if (!changed) {
            IWidgetAdapter adapter = WidgetUtil.getAdapter(coolItem);
            adapter.preserve("bounds", null);
        }
    }

    private static boolean changeOrder(CoolItem coolItem, int newOrder) {
        boolean result;
        CoolBar coolBar = coolItem.getParent();
        int itemIndex = coolBar.indexOf(coolItem);
        int[] itemOrder = coolBar.getItemOrder();
        int length = itemOrder.length;
        int[] targetOrder = new int[length];
        int index = 0;
        if (itemIndex != newOrder) {
            ICoolBarAdapter adapter;
            int i = 0;
            while (i < length) {
                if (i == newOrder) {
                    targetOrder[i] = itemOrder[itemIndex];
                } else {
                    if (index == itemIndex) {
                        ++index;
                    }
                    targetOrder[i] = itemOrder[index];
                    ++index;
                }
                ++i;
            }
            ICoolBarAdapter cba = adapter = coolBar.getAdapter(ICoolBarAdapter.class);
            cba.setItemOrder(targetOrder);
            result = true;
        } else {
            result = false;
        }
        return result;
    }
}

