/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.RWTMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ColorDialog
extends Dialog {
    private static final int BUTTON_WIDTH = 60;
    private static final int PALETTE_BOX_SIZE = 12;
    private static final int PALETTE_BOXES_IN_ROW = 14;
    private static final int COLOR_DISPLAY_BOX_SIZE = 76;
    private static final int MAX_RGB_COMPONENT_VALUE = 255;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final RGB[] PALETTE_COLORS = new RGB[]{new RGB(0, 0, 0), new RGB(70, 70, 70), new RGB(120, 120, 120), new RGB(153, 0, 48), new RGB(237, 28, 36), new RGB(255, 126, 0), new RGB(255, 194, 14), new RGB(255, 242, 0), new RGB(168, 230, 29), new RGB(34, 177, 76), new RGB(0, 183, 239), new RGB(77, 109, 243), new RGB(47, 54, 153), new RGB(111, 49, 152), new RGB(255, 255, 255), new RGB(220, 220, 220), new RGB(180, 180, 180), new RGB(156, 90, 60), new RGB(255, 163, 177), new RGB(229, 170, 122), new RGB(245, 228, 156), new RGB(255, 249, 189), new RGB(211, 249, 188), new RGB(157, 187, 97), new RGB(153, 217, 234), new RGB(112, 154, 209), new RGB(84, 109, 142), new RGB(181, 165, 213)};
    private RGB rgb;
    private Label colorDisplay;
    private Spinner spRed;
    private Spinner spBlue;
    private Spinner spGreen;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
        this.setText(RWTMessages.getMessage("RWT_ColorDialogTitle"));
    }

    public RGB open() {
        this.checkOperationMode();
        this.prepareOpen();
        this.runEventLoop(this.shell);
        return this.rgb;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    protected void prepareOpen() {
        this.createShell();
        this.createControls();
        if (this.rgb == null) {
            this.rgb = new RGB(255, 255, 255);
        }
        this.updateColorDisplay();
        this.updateSpinners();
        this.configureShell();
    }

    private void createShell() {
        this.shell = new Shell(this.parent, 67616);
        this.shell.addShellListener(new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                if (ColorDialog.this.returnCode == 256) {
                    ColorDialog.this.rgb = null;
                }
            }
        });
        this.shell.setLayout(new GridLayout(1, false));
    }

    private void createControls() {
        this.createColorArea();
        this.createPalette();
        this.createButtons();
    }

    private void createPalette() {
        Composite paletteComp = new Composite(this.shell, 0);
        GridData palData = new GridData(0x1000000, 0x1000000, true, false);
        paletteComp.setLayoutData(palData);
        paletteComp.setLayout(new GridLayout(14, true));
        Label title = new Label(paletteComp, 0);
        String titleText = RWTMessages.getMessage("RWT_ColorDialogLabelBasicColors");
        title.setText(titleText);
        GridData titleData = new GridData(16384, 0x1000000, true, false);
        titleData.horizontalSpan = 14;
        title.setLayoutData(titleData);
        int i = 0;
        while (i < PALETTE_COLORS.length) {
            this.createPaletteColorBox(paletteComp, PALETTE_COLORS[i]);
            ++i;
        }
    }

    private void createColorArea() {
        Composite areaComp = new Composite(this.shell, 0);
        GridData compData = new GridData(0x1000000, 0x1000000, true, false);
        areaComp.setLayoutData(compData);
        areaComp.setLayout(new GridLayout(2, true));
        this.colorDisplay = new Label(areaComp, 0x800800);
        GridData data = new GridData();
        data.widthHint = 76;
        data.heightHint = 76;
        this.colorDisplay.setLayoutData(data);
        Composite spinComp = new Composite(areaComp, 0);
        spinComp.setLayout(new GridLayout(2, true));
        Label rLabel = new Label(spinComp, 0);
        rLabel.setText(RWTMessages.getMessage("RWT_ColorDialogLabelRed"));
        this.spRed = new Spinner(spinComp, 2048);
        this.spRed.setMaximum(255);
        this.spRed.addModifyListener(new SpinnerListener(this.spRed, 0));
        Label gLabel = new Label(spinComp, 0);
        gLabel.setText(RWTMessages.getMessage("RWT_ColorDialogLabelGreen"));
        this.spGreen = new Spinner(spinComp, 2048);
        this.spGreen.setMaximum(255);
        this.spGreen.addModifyListener(new SpinnerListener(this.spGreen, 1));
        Label bLabel = new Label(spinComp, 0);
        bLabel.setText(RWTMessages.getMessage("RWT_ColorDialogLabelBlue"));
        this.spBlue = new Spinner(spinComp, 2048);
        this.spBlue.setMaximum(255);
        this.spBlue.addModifyListener(new SpinnerListener(this.spBlue, 2));
    }

    private void createButtons() {
        Composite composite = new Composite(this.shell, 0);
        composite.setLayout(new GridLayout(0, true));
        GridData gridData = new GridData(131072, 0x1000000, true, false);
        composite.setLayoutData(gridData);
        Button okButton = this.createButton(composite, SWT.getMessage("SWT_OK"), 32);
        this.shell.setDefaultButton(okButton);
        this.createButton(composite, SWT.getMessage("SWT_Cancel"), 256);
        okButton.forceFocus();
    }

    private void configureShell() {
        this.shell.setText(this.title);
        Rectangle parentSize = this.parent.getBounds();
        Point prefSize = this.shell.computeSize(-1, -1);
        this.shell.setSize(prefSize);
        int locationX = (parentSize.width - prefSize.x) / 2 + parentSize.x;
        int locationY = (parentSize.height - prefSize.y) / 2 + parentSize.y;
        this.shell.setLocation(new Point(locationX, locationY));
        this.shell.pack();
    }

    private void updateColorDisplay() {
        this.colorDisplay.setBackground(Graphics.getColor(this.rgb));
    }

    private void updateSpinners() {
        this.spRed.setSelection(this.rgb.red);
        this.spGreen.setSelection(this.rgb.green);
        this.spBlue.setSelection(this.rgb.blue);
    }

    private Label createPaletteColorBox(Composite parent, RGB color) {
        Label result = new Label(parent, 0x800800);
        result.setBackground(Graphics.getColor(color));
        GridData data = new GridData();
        data.widthHint = 12;
        data.heightHint = 12;
        result.setLayoutData(data);
        result.addMouseListener(new PaletteListener(color));
        return result;
    }

    private Button createButton(Composite parent, String text, final int buttonId) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button result = new Button(parent, 8);
        GridData data = new GridData(256);
        int widthHint = ColorDialog.convertHorizontalDLUsToPixels(this.shell, 60);
        Point minSize = result.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        result.setLayoutData(data);
        result.setText(text);
        result.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog.this.returnCode = buttonId;
                ColorDialog.this.shell.close();
            }
        });
        return result;
    }

    private void setColorFomSpinner(int colorIndex, int value) {
        switch (colorIndex) {
            case 0: {
                this.rgb.red = value;
                break;
            }
            case 1: {
                this.rgb.green = value;
                break;
            }
            case 2: {
                this.rgb.blue = value;
            }
        }
        this.updateColorDisplay();
    }

    private void setColorFromPalette(RGB selectedColor) {
        this.rgb.blue = selectedColor.blue;
        this.rgb.green = selectedColor.green;
        this.rgb.red = selectedColor.red;
        this.updateColorDisplay();
        this.updateSpinners();
    }

    private class PaletteListener
    extends MouseAdapter {
        private RGB rgb;

        public PaletteListener(RGB rgb) {
            this.rgb = rgb;
        }

        public void mouseDown(MouseEvent event) {
            ColorDialog.this.setColorFromPalette(this.rgb);
        }
    }

    private class SpinnerListener
    implements ModifyListener {
        private final Spinner spinner;
        private final int colorIndex;

        public SpinnerListener(Spinner spinner, int colorIndex) {
            this.spinner = spinner;
            this.colorIndex = colorIndex;
        }

        public void modifyText(ModifyEvent event) {
            ColorDialog.this.setColorFomSpinner(this.colorIndex, this.spinner.getSelection());
        }
    }
}

