/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.tabfolderkit.TabFolderThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabFolder
extends Composite {
    private static final TabItem[] EMPTY_TAB_ITEMS = new TabItem[0];
    private final ItemHolder<TabItem> itemHolder = new ItemHolder<TabItem>(TabItem.class);
    private int selectionIndex = -1;
    private boolean onBottom = (super.getStyle() & 0x400) != 0;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    @Override
    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        ItemHolder<TabItem> result = adapter == IItemHolderAdapter.class ? this.itemHolder : super.getAdapter(adapter);
        return (T)result;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        return (TabItem[])this.itemHolder.getItems();
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        return this.itemHolder.getItem(index);
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TabItem result = null;
        int i = 0;
        while (i < this.getItemCount() && result == null) {
            TabItem item = this.getItem(i);
            Rectangle itemBounds = item.getBounds();
            if (itemBounds.contains(point)) {
                result = item;
            }
            ++i;
        }
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        TabItem[] result = EMPTY_TAB_ITEMS;
        if (this.getSelectionIndex() != -1) {
            TabItem selected = this.itemHolder.getItem(this.getSelectionIndex());
            result = new TabItem[]{selected};
        }
        return result;
    }

    public void setSelection(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = this.itemHolder.size();
        if (index >= 0 && index < count) {
            this.setSelection(index, false);
        }
    }

    private void setSelection(int index, boolean notify) {
        int oldIndex = this.getSelectionIndex();
        if (oldIndex != index) {
            int newIndex;
            TabItem item;
            Control control;
            if (oldIndex != -1 && (control = (item = this.itemHolder.getItem(oldIndex)).getControl()) != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            if ((newIndex = (this.selectionIndex = index)) != -1) {
                this.updateSelectedItemControl();
                if (notify) {
                    Event event = new Event();
                    event.item = this.itemHolder.getItem(newIndex);
                    this.notifyListeners(13, event);
                }
            }
        }
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.selectionIndex >= this.itemHolder.size()) {
            this.selectionIndex = this.itemHolder.size() - 1;
        }
        return this.selectionIndex;
    }

    @Override
    public void layout() {
        this.checkWidget();
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setBounds(this.getClientArea());
            ++i;
        }
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        int border = this.getBorderWidth() + this.getContentContainerBorderWidth();
        int tabBarHeight = this.getTabBarHeight();
        int hTabBar = this.onBottom ? 0 : tabBarHeight;
        return new Rectangle(border, hTabBar + border, width - border * 2, height - (tabBarHeight + border * 2));
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = this.getBorderWidth() + this.getContentContainerBorderWidth();
        int tabBarHeight = this.getTabBarHeight();
        int hTabBar = this.onBottom ? 0 : tabBarHeight;
        int trimX = x - border;
        int trimWidth = width + 2 * border;
        int trimY = y - border - hTabBar;
        int trimHeight = height + 2 * border + tabBarHeight;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point itemsSize = new Point(0, 0);
        Point contentsSize = new Point(0, 0);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Rectangle thisItemBounds = items[i].getBounds();
            itemsSize.x += thisItemBounds.width;
            itemsSize.y = Math.max(itemsSize.y, thisItemBounds.height);
            Control control = items[i].getControl();
            if (control != null) {
                Point thisSize = control.computeSize(-1, -1);
                contentsSize.x = Math.max(contentsSize.x, thisSize.x);
                contentsSize.y = Math.max(contentsSize.y, thisSize.y);
            }
            ++i;
        }
        int width = Math.max(itemsSize.x, contentsSize.x);
        int height = itemsSize.y + contentsSize.y;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += 2 * border, height += 2 * border);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    void releaseChildren() {
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        super.releaseChildren();
    }

    void createItem(TabItem item, int index) {
        this.itemHolder.insert(item, index);
        if (this.getItemCount() == 1) {
            this.setSelection(0, true);
        }
    }

    @Override
    void notifyResize(Point oldSize) {
        super.notifyResize(oldSize);
        this.updateSelectedItemControl();
    }

    private void updateSelectedItemControl() {
        Control control;
        int index = this.getSelectionIndex();
        if (index != -1 && (control = this.getItem(index).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
    }

    private static int checkStyle(int style) {
        int result = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return result & 0xFFFFFCFF;
    }

    private int getContentContainerBorderWidth() {
        TabFolderThemeAdapter themeAdapter = (TabFolderThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getContentContainerBorderWidth(this);
    }

    private int getTabBarHeight() {
        int result = Graphics.getCharHeight(this.getFont());
        result += this.getItemPadding((boolean)true).height;
        return result += 3;
    }

    Rectangle getItemPadding(boolean selected) {
        TabFolderThemeAdapter themeAdapter = (TabFolderThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getItemPadding(true);
    }

    @Override
    void reskinChildren(int flags) {
        TabItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                TabItem item = items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }
}

