/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;

public final class JobQueue<T extends Runnable> {
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private final List<Filter<T>> filters = new CopyOnWriteArrayList<Filter<T>>();

    public void add(T job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        this.queue.add(job);
    }

    public void process() {
        ArrayList<Runnable> skipped = null;
        Runnable job = (Runnable)this.queue.poll();
        while (job != null) {
            boolean skip = false;
            for (Filter<T> filter : this.filters) {
                try {
                    if (filter.allows(job)) continue;
                    skip = true;
                    break;
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                }
            }
            if (skip) {
                if (skipped == null) {
                    skipped = new ArrayList<Runnable>();
                }
                skipped.add(job);
            } else {
                try {
                    job.run();
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                }
            }
            job = (Runnable)this.queue.poll();
        }
        if (skipped != null) {
            this.queue.addAll(skipped);
        }
    }

    public void prune(Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        Iterator itr = this.queue.iterator();
        while (itr.hasNext()) {
            if (filter.allows((Runnable)itr.next())) continue;
            itr.remove();
        }
    }

    public Disposable suspend(Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        DisposableFilter disposable = new DisposableFilter(filter);
        this.filters.add(disposable);
        return disposable;
    }

    private final class DisposableFilter
    implements Filter<T>,
    Disposable {
        private final Filter<T> base;

        public DisposableFilter(Filter<T> base) {
            this.base = base;
        }

        @Override
        public boolean allows(T element) {
            return this.base.allows(element);
        }

        @Override
        public void dispose() {
            JobQueue.this.filters.remove(this);
        }
    }
}

