/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Comparator;
import java.util.SortedSet;
import org.eclipse.sapphire.CollationService;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ListFromValueCollationService
extends CollationService {
    private CollationService base;
    private Listener listener;
    private boolean refreshing;

    @Override
    protected void initCollationService() {
        ListProperty listProperty = this.context(ListProperty.class);
        ValueProperty listMemberValueProperty = (ValueProperty)listProperty.getType().properties().first();
        this.base = listMemberValueProperty.service(CollationService.class);
        this.listener = new Listener(){

            @Override
            public void handle(Event event) {
                if (!ListFromValueCollationService.this.refreshing) {
                    try {
                        ListFromValueCollationService.this.refreshing = true;
                        ListFromValueCollationService.this.refresh();
                    }
                    finally {
                        ListFromValueCollationService.this.refreshing = false;
                    }
                }
            }
        };
        this.base.attach(this.listener);
    }

    @Override
    protected Comparator<String> compute() {
        return this.base.comparator();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.base.detach(this.listener);
            this.listener = null;
        }
        this.base = null;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ElementType memberType;
            SortedSet<PropertyDef> properties;
            Property property = context.find(Property.class);
            if (property != null && property.definition() instanceof ListProperty && property.service(PossibleTypesService.class).types().size() == 1 && (properties = (memberType = property.definition().getType()).properties()).size() == 1) {
                PropertyDef memberProperty = properties.first();
                return memberProperty instanceof ValueProperty;
            }
            return false;
        }
    }
}

