/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.MasterVersionCompatibilityService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class VersionCompatibilityValidationService
extends ValidationService {
    @Text(value="Not compatible with version {0} of {1}")
    private static LocalizableText notCompatibleWithVersionMessage;
    @Text(value="Version constraint exists, but no version constraint target was found")
    private static LocalizableText versionConstraintTargetNotFoundMessage;
    private MasterVersionCompatibilityService versionCompatibilityService;
    private Listener versionCompatibilityServiceListener;

    static {
        LocalizableText.init(VersionCompatibilityValidationService.class);
    }

    @Override
    protected void initValidationService() {
        this.versionCompatibilityService = this.context(Property.class).service(MasterVersionCompatibilityService.class);
        this.versionCompatibilityServiceListener = new Listener(){

            @Override
            public void handle(Event event) {
                VersionCompatibilityValidationService.this.refresh();
            }
        };
        this.versionCompatibilityService.attach(this.versionCompatibilityServiceListener);
    }

    @Override
    protected Status compute() {
        if (!this.versionCompatibilityService.compatible() && !this.context(Property.class).empty()) {
            Version version = this.versionCompatibilityService.version();
            String versioned = this.versionCompatibilityService.versioned();
            String message = version == null ? versionConstraintTargetNotFoundMessage.text() : notCompatibleWithVersionMessage.format(version.toString(), versioned);
            return Status.createErrorStatus(message);
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.versionCompatibilityService != null) {
            this.versionCompatibilityService.detach(this.versionCompatibilityServiceListener);
        }
    }
}

