/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.DerivedValueService;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactAddress;
import org.eclipse.sapphire.samples.contacts.PhoneNumber;
import org.eclipse.sapphire.samples.contacts.SendContactOp;

public final class SendContactOpMessageBodyDerivedValueService
extends DerivedValueService {
    protected void initDerivedValueService() {
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SendContactOpMessageBodyDerivedValueService.this.refresh();
            }
        };
        ((SendContactOp)this.context(SendContactOp.class)).getContact().attach((Listener)listener);
    }

    protected String compute() {
        SendContactOp op = (SendContactOp)this.context(SendContactOp.class);
        Contact contact = (Contact)op.getContact().content();
        StringBuilder buf = new StringBuilder();
        buf.append("<html><body>\n");
        if (contact != null) {
            ContactAddress address;
            buf.append("<b>");
            buf.append(contact.getName().text());
            buf.append("</b>\n");
            buf.append("<br/><hr/>\n");
            if (!contact.getPhoneNumbers().isEmpty()) {
                buf.append("<p><table>\n");
                for (PhoneNumber phone : contact.getPhoneNumbers()) {
                    buf.append("<tr><td><i>");
                    buf.append(phone.getType().text());
                    buf.append("</i></td><td>");
                    String areaCode = phone.getAreaCode().text();
                    String localNumber = phone.getLocalNumber().text();
                    if (areaCode != null) {
                        buf.append('(');
                        buf.append(areaCode);
                        buf.append(") ");
                    }
                    buf.append(localNumber);
                    buf.append("</td></tr>\n");
                }
                buf.append("</table></p>\n");
            }
            if ((address = contact.getAddress()) != null && address.getStreet().content() != null) {
                buf.append("<p>");
                buf.append(address.getStreet().text());
                buf.append("<br/>");
                buf.append(address.getCity().text());
                buf.append(", ");
                buf.append(address.getState().text());
                buf.append(' ');
                buf.append(address.getZipCode().text());
                buf.append("</p>\n");
            }
        }
        buf.append("</body></html>");
        return buf.toString();
    }
}

