/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.map.internal;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class ShowStatisticsActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        SapphireDiagramEditorPagePart page = (SapphireDiagramEditorPagePart)this.getPart();
        ConnectionService connService = (ConnectionService)page.service(ConnectionService.class);
        int nodes = 0;
        int connections = 0;
        int bendpoints = 0;
        for (ISapphirePart selectedPart : page.getSelections()) {
            if (selectedPart instanceof DiagramNodePart) {
                ++nodes;
                continue;
            }
            if (selectedPart instanceof DiagramConnectionPart) {
                ++connections;
                bendpoints += ((DiagramConnectionPart)selectedPart).getBendpoints().size();
                continue;
            }
            if (!(selectedPart instanceof SapphireDiagramEditorPagePart)) continue;
            nodes = page.getNodes().size();
            List allConnections = connService.list();
            connections = allConnections.size();
            for (DiagramConnectionPart connection : allConnections) {
                bendpoints += connection.getBendpoints().size();
            }
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Nodes: ").append(nodes).append('\n');
        msg.append("Connections: ").append(connections).append('\n');
        msg.append("Bend Points: ").append(bendpoints);
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Statistics", (String)msg.toString());
        return null;
    }
}

