/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.postcard;

import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.samples.postcard.FullAddress;
import org.eclipse.sapphire.samples.postcard.SendPostcardOpMethods;
import org.eclipse.sapphire.samples.postcard.Sender;

public interface SendPostcardOp
extends ExecutableElement {
    public static final ElementType TYPE = new ElementType(SendPostcardOp.class);
    @Type(base=Sender.class)
    public static final ImpliedElementProperty PROP_SENDER = new ImpliedElementProperty(TYPE, "Sender");
    @Type(base=FullAddress.class)
    public static final ImpliedElementProperty PROP_RECIPIENT = new ImpliedElementProperty(TYPE, "Recipient");
    @LongString
    public static final ValueProperty PROP_MESSAGE = new ValueProperty(TYPE, "Message");
    @Derived(text="<html><body><style type='text/css'>p{font: 14px 'Trebuchet MS', Verdana, Arial, Helvetica, sans-serif;}div{font: 14px 'Trebuchet MS', Verdana, Arial, Helvetica, sans-serif;}</style><table width='100%'><tr><td width='60%' style='padding:10px;vertical-align:top'><p>${ Sender.Name.EncodeToXml }<br/>${ Sender.Street.EncodeToXml }<br/>${ Sender.City.EncodeToXml }${ Sender.City == null ? '' : ', ' }${ Sender.State.EncodeToXml } ${ Sender.ZipCode.EncodeToXml }</p><br/><br/><p>${ Message.EncodeToXml.Replace( '\n', '<br/>' ) }</p></td><td style='border-left:2px solid black;padding:10px'><div style='border:1px solid black;float:right;padding:20px'>Stamp</div><div style='height:200px;'>&nbsp;</div><p>${ Recipient.Name.EncodeToXml }<br/>${ Recipient.Street.EncodeToXml }<br/>${ Recipient.City.EncodeToXml }${ Recipient.City == null ? '' : ', ' }${ Recipient.State.EncodeToXml } ${ Recipient.ZipCode.EncodeToXml }</p></td></tr></table></body></html>")
    public static final ValueProperty PROP_POSTCARD = new ValueProperty(TYPE, "Postcard");

    public Sender getSender();

    public FullAddress getRecipient();

    public Value<String> getMessage();

    public void setMessage(String var1);

    public Value<String> getPostcard();

    @DelegateImplementation(value=SendPostcardOpMethods.class)
    public Status execute(ProgressMonitor var1);
}

