/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.sqlschema;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sapphire.samples.sqlschema.Column;
import org.eclipse.sapphire.samples.sqlschema.ForeignKey;
import org.eclipse.sapphire.samples.sqlschema.SqlSchemaEditor;
import org.eclipse.sapphire.samples.sqlschema.Table;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.StandardConnectionService;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.swt.widgets.Display;

public final class SqlSchemaConnectionService
extends StandardConnectionService {
    public DiagramConnectionPart connect(DiagramNodePart node1, DiagramNodePart node2, String connectionType) {
        final DiagramConnectionPart fkConnectionPart = super.connect(node1, node2, connectionType);
        ForeignKey fk = (ForeignKey)fkConnectionPart.getLocalModelElement();
        Table referencedTable = (Table)fk.getReferencedTable().target();
        if (referencedTable != null) {
            for (Column column : referencedTable.getColumns()) {
                if (!((Boolean)column.getIsPrimaryKey().content()).booleanValue()) continue;
                ((ForeignKey.ColumnAssociation)fk.getColumnAssociations().insert()).setReferencedColumn((String)column.getName().content());
            }
        }
        if (!fk.getColumnAssociations().isEmpty()) {
            Table table = (Table)fk.parent().element();
            ArrayList<String> prefixes = new ArrayList<String>();
            String firstReferencedColumnName = (String)((ForeignKey.ColumnAssociation)fk.getColumnAssociations().get(0)).getReferencedColumn().content();
            for (Column column : table.getColumns()) {
                String localColumnName = (String)column.getName().content();
                if (localColumnName == null || !localColumnName.endsWith(firstReferencedColumnName)) continue;
                prefixes.add(localColumnName.substring(0, localColumnName.length() - firstReferencedColumnName.length()));
            }
            for (String prefix : prefixes) {
                boolean match = true;
                for (ForeignKey.ColumnAssociation association : fk.getColumnAssociations()) {
                    Column candidateLocalColumn = SqlSchemaConnectionService.find(table.getColumns(), String.valueOf(prefix) + (String)association.getReferencedColumn().content());
                    if (candidateLocalColumn != null && SqlSchemaConnectionService.equal(candidateLocalColumn.getType().content(), ((Column)association.getReferencedColumn().target()).getType().content())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                for (ForeignKey.ColumnAssociation association : fk.getColumnAssociations()) {
                    association.setLocalColumn(String.valueOf(prefix) + (String)association.getReferencedColumn().content());
                }
            }
        }
        SapphireWizard<ForeignKey> wizard = new SapphireWizard<ForeignKey>(fk, DefinitionLoader.sdef(SqlSchemaEditor.class).wizard("DefineForeignKeyWizard")){

            public boolean performCancel() {
                fkConnectionPart.remove();
                return true;
            }
        };
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.open();
        return fk.disposed() ? null : fkConnectionPart;
    }

    private static Column find(List<Column> columns, String name) {
        for (Column column : columns) {
            String n = (String)column.getName().content();
            if (n == null || !n.equals(name)) continue;
            return column;
        }
        return null;
    }

    public static final boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }
}

