/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0001;

import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.services.t0001.TestRootElement;
import org.eclipse.sapphire.tests.services.t0001.TestUniqueChildElement;
import org.junit.Test;

public final class TestServices0001
extends SapphireTestCase {
    @Test
    public void testPlain() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_PLAIN, new String[0]);
    }

    @Test
    public void testSensitive() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_SENSITIVE, new String[0]);
    }

    @Test
    public void testDefaultValue() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_DEFAULT_VALUE, "Default value is \"123\"");
    }

    @Test
    public void testDefaultValueSensitive() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_DEFAULT_VALUE_SENSITIVE, "Has default value");
    }

    @Test
    public void testNumericRangeMin() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_NUMERIC_RANGE_MIN, "Minimum value is 1");
    }

    @Test
    public void testNumericRangeMax() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_NUMERIC_RANGE_MAX, "Maximum value is 100");
    }

    @Test
    public void testNumericRangeMinMax() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_NUMERIC_RANGE_MIN_MAX, "Minimum value is 1", "Maximum value is 100");
    }

    @Test
    public void testRequiredValue() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_REQUIRED_VALUE, "Must be specified");
    }

    @Test
    public void testRequiredValueWithDefault() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_REQUIRED_VALUE_WITH_DEFAULT, "Default value is \"123\"");
    }

    @Test
    public void testRequiredElement() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_REQUIRED_ELEMENT, "Must be specified");
    }

    @Test
    public void testReadOnly() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_READ_ONLY, "Cannot be modified");
    }

    @Test
    public void testCountConstraintAtLeastOne() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_COUNT_CONSTRAINT_AT_LEAST_ONE, "Must have at least one");
    }

    @Test
    public void testCountConstraintMin() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_COUNT_CONSTRAINT_MIN, "Must have at least 2 items");
    }

    @Test
    public void testCountConstraintMax() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_COUNT_CONSTRAINT_MAX, "Must have at most 200 items");
    }

    @Test
    public void testCountConstraintMinMax() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_COUNT_CONSTRAINT_MIN_MAX, "Must have at least 2 items", "Must have at most 200 items");
    }

    @Test
    public void testAbsolutePath() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_ABSOLUTE_PATH, "Must be an absolute path");
    }

    @Test
    public void testMustExist() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_MUST_EXIST, "Must exist");
    }

    @Test
    public void testMustExistAbsolutePath() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_MUST_EXIST_ABSOLUTE_PATH, "Must be an absolute path", "Must exist");
    }

    @Test
    public void testUnique() throws Exception {
        TestRootElement root = (TestRootElement)TestRootElement.TYPE.instantiate();
        TestUniqueChildElement child = (TestUniqueChildElement)root.getUnique().insert();
        TestServices0001.test((Property)child.property(TestUniqueChildElement.PROP_UNIQUE), "Must be unique");
    }

    @Test
    public void testFileExtensionsOne() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_FILE_EXTENSIONS_ONE, "Must have \"xml\" file extension");
    }

    @Test
    public void testFileExtensionsTwo() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_FILE_EXTENSIONS_TWO, "Must have either \"xml\" or \"java\" file extension");
    }

    @Test
    public void testFileExtensionsThree() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_FILE_EXTENSIONS_THREE, "Must have either \"xml\", \"java\" or \"jsp\" file extension");
    }

    @Test
    public void testFileExtensionsMany() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_FILE_EXTENSIONS_MANY, "Must have one of these file extensions: \"xml\", \"java\", \"jsp\", \"jspx\"");
    }

    @Test
    public void testValidFileSystemResourceTypeFile() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_VALID_FILE_SYSTEM_RESOURCE_TYPE_FILE, "Must be a file");
    }

    @Test
    public void testValidFileSystemResourceTypeFolder() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_VALID_FILE_SYSTEM_RESOURCE_TYPE_FOLDER, "Must be a folder");
    }

    @Test
    public void testDeprecated() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_DEPRECATED, "Deprecated");
    }

    @Test
    public void testStatic() throws Exception {
        TestServices0001.test((PropertyDef)TestRootElement.PROP_STATIC_FACT, "First static fact.", "Second static fact.", "Third static fact.");
    }

    private static void test(PropertyDef property, String ... factsExpected) {
        TestServices0001.test(TestRootElement.TYPE.instantiate().property(property), factsExpected);
    }

    private static void test(Property property, String ... factsExpected) {
        TestServices0001.assertEquals(TestServices0001.set(factsExpected), (Object)((FactsAggregationService)property.service(FactsAggregationService.class)).facts());
    }
}

