/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.layout;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.MarginPresentation;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutConstraintDef;
import org.eclipse.sapphire.ui.swt.gef.layout.LayoutUtil;

public final class SapphireSequenceLayoutConstraint {
    public int verticalAlignment = 0x1000000;
    public int horizontalAlignment = 0x1000000;
    public int widthHint = -1;
    public int heightHint = -1;
    public int minWidth = -1;
    public int minHeight = -1;
    public int maxWidth = -1;
    public int maxHeight = -1;
    public boolean expandHorizontally = false;
    public boolean expandVertically = false;
    private Insets marginInsets = null;
    int cacheWidth = -1;
    int cacheHeight = -1;
    int[][] cache = new int[2][4];
    int cacheIndex = -1;

    public SapphireSequenceLayoutConstraint() {
        this(null);
    }

    public SapphireSequenceLayoutConstraint(SequenceLayoutConstraintDef def) {
        if (def != null) {
            this.horizontalAlignment = SapphireSequenceLayoutConstraint.getSwtHorizontalAlignment((HorizontalAlignment)def.getHorizontalAlignment().content());
            this.verticalAlignment = SapphireSequenceLayoutConstraint.getSwtVerticalAlignment((VerticalAlignment)def.getVerticalAlignment().content());
            this.expandHorizontally = (Boolean)def.isExpandHorizontally().content();
            this.expandVertically = (Boolean)def.isExpandVertically().content();
            this.marginInsets = LayoutUtil.calculateMargin((MarginPresentation)def);
            this.widthHint = def.getWidth().content() != null ? (Integer)def.getWidth().content() - this.marginInsets.left - this.marginInsets.right : -1;
            this.heightHint = def.getHeight().content() != null ? (Integer)def.getHeight().content() - this.marginInsets.top - this.marginInsets.bottom : -1;
            this.maxWidth = def.getMaxWidth().content() != null ? (Integer)def.getMaxWidth().content() - this.marginInsets.left - this.marginInsets.right : -1;
            this.maxHeight = def.getMaxHeight().content() != null ? (Integer)def.getMaxHeight().content() - this.marginInsets.top - this.marginInsets.bottom : -1;
            this.minWidth = def.getMinWidth().content() != null ? (Integer)def.getMinWidth().content() - this.marginInsets.left - this.marginInsets.right : -1;
            this.minHeight = def.getMinHeight().content() != null ? (Integer)def.getMinHeight().content() - this.marginInsets.top - this.marginInsets.bottom : -1;
        } else {
            this.marginInsets = new Insets(0, 0, 0, 0);
        }
    }

    Dimension computeSize(IFigure figure, boolean flushCache) {
        if (this.cacheWidth != -1 && this.cacheHeight != -1) {
            return new Dimension(this.cacheWidth, this.cacheHeight);
        }
        int i = 0;
        while (i < this.cacheIndex + 1) {
            if (this.cache[i][0] == this.widthHint && this.cache[i][1] == this.heightHint) {
                this.cacheWidth = this.cache[i][2];
                this.cacheHeight = this.cache[i][3];
                return new Dimension(this.cacheWidth, this.cacheHeight);
            }
            ++i;
        }
        Dimension size = figure.getPreferredSize(this.widthHint, this.heightHint).getCopy();
        if (this.widthHint != -1) {
            size.width = this.widthHint;
        }
        if (this.heightHint != -1) {
            size.height = this.heightHint;
        }
        if (this.cacheIndex < this.cache.length - 1) {
            ++this.cacheIndex;
        }
        this.cache[this.cacheIndex][0] = this.widthHint;
        this.cache[this.cacheIndex][1] = this.heightHint;
        int n = size.width;
        this.cache[this.cacheIndex][2] = n;
        this.cacheWidth = n;
        int n2 = size.height;
        this.cache[this.cacheIndex][3] = n2;
        this.cacheHeight = n2;
        return size;
    }

    void flushCache() {
        this.cacheHeight = -1;
        this.cacheWidth = -1;
        this.cacheIndex = -1;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public String toString() {
        String hAlign = "";
        switch (this.horizontalAlignment) {
            case 4: {
                hAlign = "SWT.FILL";
                break;
            }
            case 1: {
                hAlign = "SWT.BEGINNING";
                break;
            }
            case 16384: {
                hAlign = "SWT.LEFT";
                break;
            }
            case 0x1000008: {
                hAlign = "SWT.END";
                break;
            }
            case 131072: {
                hAlign = "SWT.RIGHT";
                break;
            }
            case 0x1000000: {
                hAlign = "SWT.CENTER";
                break;
            }
            default: {
                hAlign = "Undefined " + this.horizontalAlignment;
            }
        }
        String vAlign = "";
        switch (this.verticalAlignment) {
            case 4: {
                vAlign = "SWT.FILL";
                break;
            }
            case 1: {
                vAlign = "SWT.BEGINNING";
                break;
            }
            case 128: {
                vAlign = "SWT.TOP";
                break;
            }
            case 0x1000008: {
                vAlign = "SWT.END";
                break;
            }
            case 1024: {
                vAlign = "SWT.BOTTOM";
                break;
            }
            case 0x1000000: {
                vAlign = "SWT.CENTER";
                break;
            }
            default: {
                vAlign = "Undefined " + this.verticalAlignment;
            }
        }
        String string = String.valueOf(this.getName()) + " {";
        string = String.valueOf(string) + "horizontalAlignment=" + hAlign + " ";
        if (this.widthHint != -1) {
            string = String.valueOf(string) + "widthHint=" + this.widthHint + " ";
        }
        string = String.valueOf(string) + "verticalAlignment=" + vAlign + " ";
        if (this.heightHint != -1) {
            string = String.valueOf(string) + "heightHint=" + this.heightHint + " ";
        }
        if (this.marginInsets != null) {
            string = String.valueOf(string) + "marginInsets=" + this.marginInsets + " ";
        }
        string = String.valueOf(string) + (this.expandHorizontally ? "expandHorizontally " : "!expandHorizontally ");
        string = String.valueOf(string) + (this.expandVertically ? "expandVertically " : "!expandVertically ");
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }

    public Insets getMarginInset() {
        return this.marginInsets;
    }

    private static int getSwtHorizontalAlignment(HorizontalAlignment horizontalAlign) {
        int swtAlign = 0x1000000;
        if (horizontalAlign == HorizontalAlignment.LEFT) {
            swtAlign = 16384;
        } else if (horizontalAlign == HorizontalAlignment.RIGHT) {
            swtAlign = 131072;
        }
        return swtAlign;
    }

    private static int getSwtVerticalAlignment(VerticalAlignment verticalAlign) {
        int swtAlign = 0x1000000;
        if (verticalAlign == VerticalAlignment.TOP) {
            swtAlign = 128;
        } else if (verticalAlign == VerticalAlignment.BOTTOM) {
            swtAlign = 1024;
        }
        return swtAlign;
    }
}

