/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.util.SetFactory;

public final class MultiValueMap<K, V> {
    private final Map<K, Object> map = new HashMap<K, Object>();

    public Set<V> get(K key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        SetFactory valueSetFactory = SetFactory.start();
        if (value instanceof Set) {
            for (Object obj : (Set)value) {
                valueSetFactory.add(obj);
            }
        } else {
            valueSetFactory.add(value);
        }
        return valueSetFactory.result();
    }

    public void put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (value != null) {
            Object existing = this.map.get(key);
            if (existing == null) {
                this.map.put(key, value);
            } else if (existing instanceof Set) {
                ((Set)existing).add(value);
            } else if (!existing.equals(value)) {
                HashSet<Object> set = new HashSet<Object>(2);
                set.add(existing);
                set.add(value);
                this.map.put(key, set);
            }
        }
    }

    public void remove(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Object existing = this.map.get(key);
        if (existing != null) {
            if (existing instanceof Set) {
                Set set = (Set)existing;
                set.remove(value);
                if (set.isEmpty()) {
                    this.map.remove(key);
                }
            } else if (existing.equals(value)) {
                this.map.remove(key);
            }
        }
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }
}

