/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class DeleteAllBendPointsForMultiplePartsActionHandler
extends SapphireActionHandler {
    private List<DiagramConnectionPart> selectedConnectionParts = new ArrayList<DiagramConnectionPart>();
    private Listener connectionPartListener = new FilteredListener<ConnectionBendpointsEvent>(){

        protected void handleTypedEvent(ConnectionBendpointsEvent event) {
            DeleteAllBendPointsForMultiplePartsActionHandler.this.broadcast(new SapphireActionSystemPart.EnablementChangedEvent());
        }
    };

    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        SapphireDiagramEditorPagePart part = (SapphireDiagramEditorPagePart)this.getPart();
        part.attach(new Listener(){

            public void handle(Event e) {
                if (e instanceof SapphireEditorPagePart.SelectionChangedEvent) {
                    DeleteAllBendPointsForMultiplePartsActionHandler.this.broadcast(new SapphireActionSystemPart.EnablementChangedEvent());
                    DeleteAllBendPointsForMultiplePartsActionHandler.this.refreshConnectionPartsListener();
                }
            }
        });
        this.refreshConnectionPartsListener();
    }

    @Override
    public boolean isEnabled() {
        SapphireDiagramEditorPagePart page = (SapphireDiagramEditorPagePart)this.getPart();
        for (ISapphirePart selectedPart : page.getSelections()) {
            if (!(selectedPart instanceof DiagramConnectionPart) || ((DiagramConnectionPart)selectedPart).getBendpoints().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object run(Presentation context) {
        SapphireDiagramEditorPagePart page = (SapphireDiagramEditorPagePart)this.getPart();
        for (ISapphirePart selectedPart : page.getSelections()) {
            if (!(selectedPart instanceof DiagramConnectionPart)) continue;
            ((DiagramConnectionPart)selectedPart).removeAllBendpoints();
        }
        return null;
    }

    private void refreshConnectionPartsListener() {
        for (DiagramConnectionPart connPart : this.selectedConnectionParts) {
            connPart.detach(this.connectionPartListener);
        }
        SapphireDiagramEditorPagePart pagePart = (SapphireDiagramEditorPagePart)this.getPart();
        ArrayList<DiagramConnectionPart> newSelectedParts = new ArrayList<DiagramConnectionPart>();
        for (ISapphirePart part : pagePart.getSelections()) {
            if (!(part instanceof DiagramConnectionPart)) continue;
            newSelectedParts.add((DiagramConnectionPart)part);
            ((DiagramConnectionPart)part).attach(this.connectionPartListener);
        }
        this.selectedConnectionParts.clear();
        this.selectedConnectionParts.addAll(newSelectedParts);
    }
}

