/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.ActuatorActionHandlerEvent;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ImageReference;
import org.eclipse.sapphire.ui.forms.ActuatorDef;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.internal.ActuatorButtonPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.ActuatorLinkPresentation;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Composite;

public final class ActuatorPart
extends FormComponentPart {
    @Text(value="Actuator label not specified")
    private static LocalizableText labelNotSpecified;
    private SapphireAction action;
    private String actionId;
    private Listener actionListener;
    private SapphireActionHandler actionHandler;
    private String actionHandlerId;
    private Listener actionHandlerListener;
    private boolean showLabel;
    private FunctionResult labelFunctionResult;
    private boolean showImage;
    private List<FunctionResult> imageFunctionResults;
    private String style;

    static {
        LocalizableText.init(ActuatorPart.class);
    }

    @Override
    protected void init() {
        super.init();
        ActuatorDef def = this.definition();
        this.actionId = (String)def.getActionId().content();
        this.actionHandlerId = (String)def.getActionHandlerId().content();
        this.showLabel = (Boolean)def.getShowLabel().content();
        if (this.showLabel) {
            this.labelFunctionResult = this.initExpression((Function)def.getLabel().content(), String.class, null, new Runnable(){

                @Override
                public void run() {
                    ActuatorPart.this.broadcast(new SapphirePart.LabelChangedEvent(ActuatorPart.this));
                }
            });
        }
        this.showImage = (Boolean)def.getShowImage().content();
        if (this.showImage) {
            ListFactory imageFunctionResultsFactory = ListFactory.start();
            for (ImageReference imageReference : def.getImages()) {
                FunctionResult imageFunctionResult = this.initExpression((Function)imageReference.getImage().content(), ImageData.class, null, new Runnable(){

                    @Override
                    public void run() {
                        ActuatorPart.this.broadcast(new SapphirePart.ImageChangedEvent(ActuatorPart.this));
                    }
                });
                imageFunctionResultsFactory.add((Object)imageFunctionResult);
            }
            this.imageFunctionResults = imageFunctionResultsFactory.result();
        }
        this.style = (String)def.getStyle().content();
    }

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), new Function(){

            public String name() {
                return "VisibleIfActionHandlerExists";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected void init() {
                        ActuatorPart.this.attach((Listener)new FilteredListener<ActuatorActionHandlerEvent>(){

                            protected void handleTypedEvent(ActuatorActionHandlerEvent event) {
                                this.refresh();
                            }
                        });
                    }

                    protected Object evaluate() {
                        if (ActuatorPart.this.handler() != null) {
                            return true;
                        }
                        return false;
                    }
                };
            }
        }});
    }

    private void refreshActionHandler() {
        SapphireActionHandler oldActionHandler = this.actionHandler;
        if (this.actionHandler != null) {
            this.actionHandler.detach(this.actionHandlerListener);
            this.actionHandler = null;
        }
        SapphireAction action = this.action();
        if (this.actionHandlerId == null) {
            this.actionHandler = action.getFirstActiveHandler();
        } else {
            for (SapphireActionHandler h : action.getActiveHandlers()) {
                if (!h.getId().equalsIgnoreCase(this.actionHandlerId)) continue;
                this.actionHandler = h;
                break;
            }
        }
        if (this.actionHandler != null) {
            if (this.actionHandlerListener == null) {
                this.actionHandlerListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                            ActuatorPart.this.broadcast(new EnablementChangedEvent(ActuatorPart.this));
                        }
                    }
                };
            }
            this.actionHandler.attach(this.actionHandlerListener);
        }
        if (this.actionHandler != oldActionHandler) {
            this.broadcast(new ActuatorActionHandlerEvent(this));
        }
    }

    @Override
    public ActuatorDef definition() {
        return (ActuatorDef)super.definition();
    }

    public SapphireAction action() {
        if (this.action == null) {
            this.action = this.getAction(this.actionId);
            this.actionListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphireAction.HandlersChangedEvent) {
                        ActuatorPart.this.refreshActionHandler();
                    } else if (event instanceof SapphireActionSystemPart.LabelChangedEvent) {
                        ActuatorPart.this.broadcast(new SapphirePart.LabelChangedEvent(ActuatorPart.this));
                    } else if (event instanceof SapphireActionSystemPart.ImagesChangedEvent) {
                        ActuatorPart.this.broadcast(new SapphirePart.ImageChangedEvent(ActuatorPart.this));
                    }
                }
            };
            this.action.attach(this.actionListener);
        }
        return this.action;
    }

    public SapphireActionHandler handler() {
        if (this.actionHandler == null) {
            this.refreshActionHandler();
        }
        return this.actionHandler;
    }

    public boolean enabled() {
        SapphireActionHandler handler = this.handler();
        return handler != null && handler.isEnabled();
    }

    public String label() {
        return this.label(CapitalizationType.NO_CAPS);
    }

    public String label(CapitalizationType capitalizationType) {
        return this.label(capitalizationType, false);
    }

    public String label(CapitalizationType capitalizationType, boolean includeMnemonic) {
        if (this.showLabel) {
            SapphireAction action;
            String label = (String)this.labelFunctionResult.value();
            if (label == null && (action = this.action()) != null) {
                label = action.getLabel();
            }
            LocalizationService localizationService = (LocalizationService)this.definition.adapt(LocalizationService.class);
            return localizationService.text(label, capitalizationType, includeMnemonic);
        }
        return null;
    }

    public ImageData image(int size) {
        if (this.showImage) {
            for (FunctionResult imageFunctionResult : this.imageFunctionResults) {
                ImageData image = (ImageData)imageFunctionResult.value();
                if (image == null || SwtUtil.sizeOfImage(image) != size) continue;
                return image;
            }
            SapphireAction action = this.action();
            if (action != null) {
                return action.getImage(size);
            }
        }
        return null;
    }

    public String style() {
        return this.style;
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        if (this.style().equals("Sapphire.Actuator.Button")) {
            return new ActuatorButtonPresentation(this, parent, composite);
        }
        return new ActuatorLinkPresentation(this, parent, composite);
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Actuator");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.action != null) {
            this.action.detach(this.actionListener);
        }
        if (this.actionHandler != null) {
            this.actionHandler.detach(this.actionHandlerListener);
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.imageFunctionResults != null) {
            for (FunctionResult imageFunctionResult : this.imageFunctionResults) {
                imageFunctionResult.dispose();
            }
        }
    }

    public static final class EnablementChangedEvent
    extends SapphirePart.PartEvent {
        public EnablementChangedEvent(SapphirePart part) {
            super(part);
        }
    }
}

