/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.VersionCompatibilityService;
import org.eclipse.sapphire.VersionCompatibilityTargetService;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.modeling.el.ConcatFunction;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DeclarativeVersionCompatibilityService
extends VersionCompatibilityService {
    private VersionCompatibilityTargetService versionCompatibilityTargetService;
    private Listener versionCompatibilityTargetServiceListener;
    private FunctionResult functionResult;

    @Override
    protected void initVersionCompatibilityService() {
        Element element = this.context(Element.class);
        PropertyDef property = this.context(PropertyDef.class);
        this.versionCompatibilityTargetService = VersionCompatibilityTargetService.find(element, property);
        this.versionCompatibilityTargetServiceListener = new Listener(){

            @Override
            public void handle(Event event) {
                DeclarativeVersionCompatibilityService.this.refresh();
            }
        };
        this.versionCompatibilityTargetService.attach(this.versionCompatibilityTargetServiceListener);
        Function function = null;
        VersionCompatibility versionCompatibilityAnnotation = property.getAnnotation(VersionCompatibility.class);
        if (versionCompatibilityAnnotation != null) {
            try {
                function = ExpressionLanguageParser.parse(versionCompatibilityAnnotation.value());
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        } else {
            Since sinceAnnotation = property.getAnnotation(Since.class);
            try {
                function = ExpressionLanguageParser.parse(sinceAnnotation.value());
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
            if (function != null) {
                function = ConcatFunction.create("[", function);
            }
        }
        if (function == null) {
            function = Literal.NULL;
        } else {
            function = FailSafeFunction.create(function, Literal.create(VersionConstraint.class), null);
            this.functionResult = function.evaluate(new ModelElementFunctionContext(element));
            this.functionResult.attach(new Listener(){

                @Override
                public void handle(Event event) {
                    DeclarativeVersionCompatibilityService.this.refresh();
                }
            });
        }
    }

    @Override
    protected Data compute() {
        Version version = this.versionCompatibilityTargetService.version();
        String versioned = this.versionCompatibilityTargetService.versioned();
        boolean compatible = false;
        VersionConstraint constraint = (VersionConstraint)this.functionResult.value();
        if (constraint != null && version != null) {
            compatible = constraint.check(version);
        }
        return new Data(versioned, version, constraint, compatible);
    }

    public VersionConstraint constraint() {
        Data data = (Data)this.data();
        return data == null ? null : data.constraint();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.versionCompatibilityTargetService != null) {
            this.versionCompatibilityTargetService.detach(this.versionCompatibilityTargetServiceListener);
        }
        if (this.functionResult != null) {
            try {
                this.functionResult.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Element element = context.find(Element.class);
            PropertyDef property = context.find(PropertyDef.class);
            return (property.hasAnnotation(VersionCompatibility.class) || property.hasAnnotation(Since.class)) && VersionCompatibilityTargetService.find(element, property) != null;
        }
    }

    public static final class Data
    extends VersionCompatibilityService.Data {
        private final VersionConstraint constraint;

        public Data(String versioned, Version version, VersionConstraint constraint, boolean compatible) {
            super(compatible, version, versioned);
            this.constraint = constraint;
        }

        public VersionConstraint constraint() {
            return this.constraint;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Data) {
                Data data = (Data)obj;
                return super.equals(obj) && MiscUtil.equal(this.constraint, data.constraint);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (this.constraint == null ? 0 : this.constraint.hashCode());
        }
    }
}

