/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el.parser;

import java.io.StringReader;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.parser.internal.ExpressionLanguageParserImpl;
import org.eclipse.sapphire.modeling.el.parser.internal.TokenMgrError;

public final class ExpressionLanguageParser {
    @Text(value="Failed while parsing an expression: {0}")
    private static LocalizableText parseFailedMessage;

    static {
        LocalizableText.init(ExpressionLanguageParser.class);
    }

    public static Function parse(String expression) {
        ExpressionLanguageParserImpl parser = new ExpressionLanguageParserImpl(new StringReader(expression));
        try {
            return parser.Start();
        }
        catch (TokenMgrError e) {
            throw new FunctionException(Status.createErrorStatus(parseFailedMessage.format(expression), e));
        }
        catch (Exception e) {
            throw new FunctionException(Status.createErrorStatus(parseFailedMessage.format(expression), e));
        }
    }
}

