/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Type;
import org.eclipse.sapphire.Unique;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.samples.contacts.Assistant;
import org.eclipse.sapphire.samples.contacts.Connection;
import org.eclipse.sapphire.samples.contacts.ContactAddress;
import org.eclipse.sapphire.samples.contacts.HomemakerOccupation;
import org.eclipse.sapphire.samples.contacts.JobOccupation;
import org.eclipse.sapphire.samples.contacts.Occupation;
import org.eclipse.sapphire.samples.contacts.PhoneNumber;
import org.eclipse.sapphire.samples.contacts.StudentOccupation;
import org.eclipse.sapphire.samples.contacts.WebSite;
import org.eclipse.sapphire.samples.contacts.internal.ConnectionsListBinding;
import org.eclipse.sapphire.samples.contacts.internal.ContactCategoryPossibleValueService;
import org.eclipse.sapphire.samples.contacts.internal.ContactEqualityService;
import org.eclipse.sapphire.samples.contacts.internal.ContactImageService;
import org.eclipse.sapphire.samples.contacts.internal.ContactMethods;

@Image(path="Contact.png")
@Services(value={@Service(impl=ContactImageService.class), @Service(impl=ContactEqualityService.class)})
public interface Contact
extends Element {
    public static final ElementType TYPE = new ElementType(Contact.class);
    @Label(standard="name")
    @Required
    @Unique
    @XmlBinding(path="@name")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Label(standard="category")
    @DefaultValue(text="Personal")
    @Service(impl=ContactCategoryPossibleValueService.class)
    @XmlBinding(path="%category")
    @Documentation(content="This would be the help content for the category property.")
    public static final ValueProperty PROP_CATEGORY = new ValueProperty(TYPE, "Category");
    @Label(standard="E-Mail")
    @XmlBinding(path="e-mail")
    public static final ValueProperty PROP_E_MAIL = new ValueProperty(TYPE, "EMail");
    @Type(base=PhoneNumber.class)
    @Label(standard="phone numbers")
    @XmlListBinding(path="phone-numbers", mappings={@XmlListBinding.Mapping(element="phone-number", type=PhoneNumber.class)})
    public static final ListProperty PROP_PHONE_NUMBERS = new ListProperty(TYPE, "PhoneNumbers");
    @Type(base=WebSite.class)
    @Label(standard="web sites")
    @XmlListBinding(path="web-sites", mappings={@XmlListBinding.Mapping(element="web-site", type=WebSite.class)})
    public static final ListProperty PROP_WEB_SITES = new ListProperty(TYPE, "WebSites");
    @Type(base=ContactAddress.class)
    @XmlBinding(path="address")
    public static final ImpliedElementProperty PROP_ADDRESS = new ImpliedElementProperty(TYPE, "Address");
    @Type(base=Assistant.class)
    @Label(standard="assistant")
    @XmlBinding(path="assistant")
    @Documentation(content="The individual to whom the contact delegates certain tasks.")
    public static final ElementProperty PROP_ASSISTANT = new ElementProperty(TYPE, "Assistant");
    @Label(standard="connections")
    @Type(base=Connection.class)
    @CustomXmlListBinding(impl=ConnectionsListBinding.class)
    public static final ListProperty PROP_CONNECTIONS = new ListProperty(TYPE, "Connections");
    @Type(base=Occupation.class, possible={JobOccupation.class, StudentOccupation.class, HomemakerOccupation.class})
    @Label(standard="primary occupation")
    @XmlElementBinding(path="primary-occupation", mappings={@XmlElementBinding.Mapping(element="job", type=JobOccupation.class), @XmlElementBinding.Mapping(element="student", type=StudentOccupation.class), @XmlElementBinding.Mapping(element="homemaker", type=HomemakerOccupation.class)})
    @Documentation(content="The contact's primary occupation, such as a job.")
    public static final ElementProperty PROP_PRIMARY_OCCUPATION = new ElementProperty(TYPE, "PrimaryOccupation");

    public Value<String> getName();

    public void setName(String var1);

    public Value<String> getCategory();

    public void setCategory(String var1);

    public Value<String> getEMail();

    public void setEMail(String var1);

    public ElementList<PhoneNumber> getPhoneNumbers();

    public ElementList<WebSite> getWebSites();

    @DelegateImplementation(value=ContactMethods.class)
    public void removePhoneNumbersByAreaCode(String var1);

    public ContactAddress getAddress();

    public ElementHandle<Assistant> getAssistant();

    public ElementList<Connection> getConnections();

    public ElementHandle<Occupation> getPrimaryOccupation();
}

