/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.map.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.samples.map.Location;
import org.eclipse.sapphire.samples.map.Map;
import org.eclipse.sapphire.ui.DragAndDropService;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class MapDragAndDropService
extends DragAndDropService {
    public boolean droppable(DragAndDropService.DropContext context) {
        return context.object() instanceof IFile;
    }

    public void drop(DragAndDropService.DropContext context) {
        IFile file = (IFile)context.object();
        ArrayList<String> locations = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStream in = file.getContents();){
                BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                String line = br.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        locations.add(line);
                    }
                    line = br.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        catch (IOException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        if (!locations.isEmpty()) {
            SapphireDiagramEditorPagePart diagram = (SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class);
            Map map = (Map)this.context(Map.class);
            Point initialDropPosition = context.position();
            int x = initialDropPosition.getX();
            int y = initialDropPosition.getY();
            for (String locationName : locations) {
                if (map.hasLocation(locationName)) continue;
                Location location = (Location)map.getLocations().insert();
                location.setName(locationName);
                DiagramNodePart locationNodePart = diagram.getDiagramNodePart((Element)location);
                locationNodePart.setNodeBounds(x, y);
                x += 50;
                y += 50;
            }
        }
    }
}

