/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.po;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.samples.po.PurchaseComputerOp;
import org.eclipse.sapphire.samples.po.PurchaseOrder;
import org.eclipse.sapphire.samples.po.PurchaseOrderEntry;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.widgets.Display;

public final class PurchaseComputerOpMethods {
    public static final Status execute(final PurchaseComputerOp context, final ProgressMonitor monitor) {
        Display display = Display.getDefault();
        if (display.getThread() != Thread.currentThread()) {
            final MutableReference result = new MutableReference();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    result.set((Object)PurchaseComputerOpMethods.execute(context, monitor));
                }
            });
            return (Status)result.get();
        }
        PurchaseOrder po = (PurchaseOrder)context.getPurchaseOrder().content();
        PurchaseComputerOpMethods.add(po, (String)context.getProcessor().content());
        PurchaseComputerOpMethods.add(po, (String)context.getMemory().content());
        PurchaseComputerOpMethods.add(po, (String)context.getStorage().content());
        PurchaseComputerOpMethods.add(po, (String)context.getVideoCard().content());
        return Status.createOkStatus();
    }

    private static void add(PurchaseOrder po, String item) {
        Matcher matcher;
        if (item != null && (matcher = Pattern.compile("(.*) - \\$([0-9]+)").matcher(item)).find()) {
            PurchaseOrderEntry entry = (PurchaseOrderEntry)po.getEntries().insert();
            entry.setDescription(matcher.group(1));
            entry.setItem(Integer.toHexString(((String)entry.getDescription().content()).hashCode()).toUpperCase());
            entry.setUnitPrice(matcher.group(2));
        }
    }
}

