/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.internal;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.InitialValueService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.jdt.JdtUtil;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.sdk.CreateExtensionManifestOp;
import org.eclipse.sapphire.services.ValidationService;

public final class CreateExtensionManifestOpServices {
    @Text(value="Sapphire extension manifest should be placed in the META-INF folder")
    private static LocalizableText invalidFolder;

    static {
        LocalizableText.init(CreateExtensionManifestOpServices.class);
    }

    private CreateExtensionManifestOpServices() {
    }

    public static final class FolderInitialValueService
    extends InitialValueService {
        private Listener listener;

        protected void initInitialValueService() {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    this.refresh();
                }
            };
            ((CreateExtensionManifestOp)this.context(CreateExtensionManifestOp.class)).property(CreateExtensionManifestOp.PROP_CONTEXT).attach(this.listener);
        }

        protected String compute() {
            CreateExtensionManifestOp op = (CreateExtensionManifestOp)this.context(CreateExtensionManifestOp.class);
            IResource context = (IResource)op.getContext().content();
            IFolder result = null;
            if (context != null) {
                IProject project = context.getProject();
                List sourceFolders = JdtUtil.findSourceFolders((IProject)project);
                IPath resourceFullPath = context.getFullPath();
                IContainer contextSourceFolder = null;
                for (IContainer sourceFolder : sourceFolders) {
                    if (!sourceFolder.getFullPath().isPrefixOf(resourceFullPath)) continue;
                    contextSourceFolder = sourceFolder;
                    break;
                }
                if (contextSourceFolder != null && !(result = contextSourceFolder.getFolder((IPath)new Path("META-INF"))).isAccessible()) {
                    result = null;
                }
                if (result == null && !(result = project.getFolder((IPath)new Path("META-INF"))).isAccessible()) {
                    result = context instanceof IContainer ? (IContainer)context : context.getParent();
                }
            }
            return result == null ? null : result.getFullPath().makeRelative().toPortableString();
        }

        public void dispose() {
            CreateExtensionManifestOp op;
            super.dispose();
            if (this.listener != null && !(op = (CreateExtensionManifestOp)this.context(CreateExtensionManifestOp.class)).disposed()) {
                op.property(CreateExtensionManifestOp.PROP_CONTEXT).detach(this.listener);
            }
        }
    }

    public static final class FolderValidationService
    extends ValidationService {
        protected Status compute() {
            String lastSegment;
            org.eclipse.sapphire.modeling.Path path = (org.eclipse.sapphire.modeling.Path)((Value)this.context(Value.of(org.eclipse.sapphire.modeling.Path.class))).content();
            if (path != null && (lastSegment = path.lastSegment()) != null && !lastSegment.equals("META-INF")) {
                return Status.createWarningStatus((String)invalidFolder.text());
            }
            return Status.createOkStatus();
        }
    }
}

