/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.index;

import java.util.Set;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Index;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.index.TestElement;
import org.eclipse.sapphire.tests.index.TestElementWithEqualityService;
import org.eclipse.sapphire.tests.index.TestElementWithInheritedProperty;
import org.eclipse.sapphire.util.Comparators;
import org.junit.Test;

public final class IndexTests
extends SapphireTestCase {
    @Test
    public void testSingleIndex() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ElementList<TestElement.ListEntry> list = element.getList();
            int i = 0;
            while (i < 100) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i));
                ++i;
            }
            Index index = list.index(TestElement.ListEntry.PROP_STRING_VALUE);
            IndexTests.assertSame(list, (Object)index.list());
            IndexTests.assertSame((Object)TestElement.ListEntry.PROP_STRING_VALUE, (Object)index.property());
            IndexTests.assertSame((Object)index, (Object)list.index(TestElement.ListEntry.PROP_STRING_VALUE));
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "20", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "97", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "137", 0);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, null, 0);
            int i2 = 100;
            while (i2 < 200) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i2));
                ++i2;
            }
            list.insert();
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "137", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, null, 1);
            i2 = 100;
            while (i2 < 200) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i2));
                ++i2;
            }
            list.insert();
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "20", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "97", 1);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "137", 2);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "182", 2);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, "213", 0);
            this.testIndexLookup((Index<TestElement.ListEntry>)index, null, 2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testMultipleIndexes() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ElementList<TestElement.ListEntry> list = element.getList();
            int i = 0;
            while (i < 100) {
                TestElement.ListEntry entry = (TestElement.ListEntry)list.insert();
                entry.setStringValue("s" + String.valueOf(i));
                entry.setIntegerValue(i);
                ++i;
            }
            Index stringValueIndex = list.index(TestElement.ListEntry.PROP_STRING_VALUE);
            IndexTests.assertSame(list, (Object)stringValueIndex.list());
            IndexTests.assertSame((Object)TestElement.ListEntry.PROP_STRING_VALUE, (Object)stringValueIndex.property());
            IndexTests.assertSame((Object)stringValueIndex, (Object)list.index(TestElement.ListEntry.PROP_STRING_VALUE));
            Index integerValueIndex = list.index(TestElement.ListEntry.PROP_INTEGER_VALUE);
            IndexTests.assertSame(list, (Object)integerValueIndex.list());
            IndexTests.assertSame((Object)TestElement.ListEntry.PROP_INTEGER_VALUE, (Object)integerValueIndex.property());
            IndexTests.assertSame((Object)integerValueIndex, (Object)list.index(TestElement.ListEntry.PROP_INTEGER_VALUE));
            IndexTests.assertSame((Object)stringValueIndex.element("s97"), (Object)integerValueIndex.element("97"));
            int i2 = 100;
            while (i2 < 200) {
                ((TestElement.ListEntry)list.insert()).setStringValue(String.valueOf(i2));
                ++i2;
            }
            IndexTests.assertSame((Object)stringValueIndex.element("s137"), (Object)integerValueIndex.element("137"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testIndexCaseSensitivity() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ElementList<TestElement.ListEntry> list = element.getList();
            int i = 0;
            while (i < 100) {
                ((TestElement.ListEntry)list.insert()).setStringValue("abc" + String.valueOf(i));
                ++i;
            }
            Index respectCaseIndex = list.index(TestElement.ListEntry.PROP_STRING_VALUE);
            IndexTests.assertSame((Object)respectCaseIndex, (Object)list.index(TestElement.ListEntry.PROP_STRING_VALUE));
            Index ignoreCaseIndex = list.index(TestElement.ListEntry.PROP_STRING_VALUE, Comparators.createIgnoreCaseComparator());
            IndexTests.assertSame((Object)ignoreCaseIndex, (Object)list.index(TestElement.ListEntry.PROP_STRING_VALUE, Comparators.createIgnoreCaseComparator()));
            IndexTests.assertNotSame((Object)ignoreCaseIndex, (Object)respectCaseIndex);
            IndexTests.assertEquals((long)1L, (long)respectCaseIndex.elements("abc97").size());
            IndexTests.assertEquals((long)0L, (long)respectCaseIndex.elements("AbC97").size());
            IndexTests.assertEquals((long)1L, (long)ignoreCaseIndex.elements("abc97").size());
            IndexTests.assertEquals((long)1L, (long)ignoreCaseIndex.elements("AbC97").size());
            IndexTests.assertEquals((Object)ignoreCaseIndex.elements("abc97"), (Object)ignoreCaseIndex.elements("AbC97"));
            int i2 = 0;
            while (i2 < 100) {
                ((TestElement.ListEntry)list.insert()).setStringValue("AbC" + String.valueOf(i2));
                ++i2;
            }
            IndexTests.assertEquals((long)1L, (long)respectCaseIndex.elements("abc97").size());
            IndexTests.assertEquals((long)1L, (long)respectCaseIndex.elements("AbC97").size());
            IndexTests.assertEquals((long)0L, (long)respectCaseIndex.elements("ABC97").size());
            IndexTests.assertFalse((boolean)respectCaseIndex.elements("abc97").equals(respectCaseIndex.elements("AbC97")));
            IndexTests.assertEquals((long)2L, (long)ignoreCaseIndex.elements("abc97").size());
            IndexTests.assertEquals((long)2L, (long)ignoreCaseIndex.elements("AbC97").size());
            IndexTests.assertEquals((long)2L, (long)ignoreCaseIndex.elements("ABC97").size());
            IndexTests.assertEquals((Object)ignoreCaseIndex.elements("abc97"), (Object)ignoreCaseIndex.elements("AbC97"));
            IndexTests.assertEquals((Object)ignoreCaseIndex.elements("abc97"), (Object)ignoreCaseIndex.elements("ABC97"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testIndexEvents() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ElementList<TestElement.ListEntry> list = element.getList();
            int i = 0;
            while (i < 100) {
                TestElement.ListEntry entry = (TestElement.ListEntry)list.insert();
                entry.setStringValue(String.valueOf(i));
                entry.setIntegerValue(i);
                ++i;
            }
            Index index = list.index(TestElement.ListEntry.PROP_STRING_VALUE);
            EventLog log = new EventLog();
            index.attach((Listener)log);
            index.element("1");
            IndexTests.assertEquals((long)0L, (long)log.size());
            list.remove(0);
            IndexTests.assertEquals((long)1L, (long)log.size());
            log.clear();
            ((TestElement.ListEntry)list.get(10)).setStringValue("aa");
            IndexTests.assertEquals((long)1L, (long)log.size());
            log.clear();
            ((TestElement.ListEntry)list.get(10)).setIntegerValue(9999);
            IndexTests.assertEquals((long)0L, (long)log.size());
            list.moveUp(list.get(10));
            IndexTests.assertEquals((long)0L, (long)log.size());
            list.moveDown(list.get(20));
            IndexTests.assertEquals((long)0L, (long)log.size());
            index.detach((Listener)log);
            list.remove(0);
            IndexTests.assertEquals((long)0L, (long)log.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testIndexWithEqualityService() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElementWithEqualityService element = (TestElementWithEqualityService)TestElementWithEqualityService.TYPE.instantiate();){
            ElementList<TestElementWithEqualityService.ListEntry> list = element.getList();
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("a");
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("b");
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("a");
            Index index = list.index(TestElementWithEqualityService.ListEntry.PROP_VALUE);
            IndexTests.assertEquals((long)2L, (long)index.elements("a").size());
            IndexTests.assertEquals((long)1L, (long)index.elements("b").size());
            ((TestElementWithEqualityService.ListEntry)list.insert()).setValue("b");
            IndexTests.assertEquals((long)2L, (long)index.elements("b").size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testIndexWithInheritedProperty() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElementWithInheritedProperty element = (TestElementWithInheritedProperty)TestElementWithInheritedProperty.TYPE.instantiate();){
            ElementList<TestElementWithInheritedProperty.ListEntry> list = element.getList();
            ((TestElementWithInheritedProperty.ListEntry)list.insert()).setValue("a");
            ((TestElementWithInheritedProperty.ListEntry)list.insert()).setValue("b");
            Index index = list.index(TestElementWithInheritedProperty.ListEntry.PROP_VALUE);
            IndexTests.assertNotNull((Object)index.element("a"));
            IndexTests.assertNotNull((Object)index.element("b"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_ValueProperty_Null() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_ValueProperty_Foreign_1() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index(TestElement.PROP_VALUE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_ValueProperty_Foreign_2() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index(TestElement.ListEntry.NestedListEntry.PROP_VALUE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_ElementList_Index_ValueProperty_Disposed() {
        ElementList<TestElement.ListEntry> list;
        Throwable throwable = null;
        Object var3_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            list = element.getList();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        list.index(TestElement.ListEntry.PROP_STRING_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_Null() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_Unknown() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index("Value");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_Path() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index("List/Value");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_ElementList_Index_String_List() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index("List");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_ElementList_Index_String_Disposed() {
        ElementList<TestElement.ListEntry> list;
        Throwable throwable = null;
        Object var3_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            list = element.getList();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        list.index(TestElement.ListEntry.PROP_STRING_VALUE);
    }

    @Test(expected=IllegalStateException.class)
    public void testException_Index_Element_Disposed() {
        Index index;
        Throwable throwable = null;
        Object var3_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            index = element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        index.element("a");
    }

    @Test(expected=IllegalStateException.class)
    public void testException_Index_Elements_Disposed() {
        Index index;
        Throwable throwable = null;
        Object var3_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            index = element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        index.elements("a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_Index_Attach_Null() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE).attach(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testException_Index_Attach_Disposed() {
        Index index;
        Throwable throwable = null;
        Object var3_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            index = element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        index.attach((Listener)new EventLog());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testException_Index_Detach_Null() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getList().index(TestElement.ListEntry.PROP_STRING_VALUE).detach(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testIndexLookup(Index<TestElement.ListEntry> index, String key, int count) {
        if (count == 0) {
            IndexTests.assertNull((Object)index.element(key));
            Set elements = index.elements(key);
            IndexTests.assertNotNull((Object)elements);
            IndexTests.assertEquals((long)0L, (long)elements.size());
        } else {
            TestElement.ListEntry element = (TestElement.ListEntry)index.element(key);
            IndexTests.assertNotNull((Object)element);
            IndexTests.assertEquals((Object)key, (Object)element.property(index.property()).text());
            Set elements = index.elements(key);
            IndexTests.assertNotNull((Object)elements);
            IndexTests.assertEquals((long)count, (long)elements.size());
            for (TestElement.ListEntry entry : elements) {
                IndexTests.assertEquals((Object)key, (Object)entry.property(index.property()).text());
            }
        }
    }
}

