/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.content;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.content.TestElement;
import org.junit.Test;

public final class ContentFunctionTests
extends TestExpr {
    @Test
    public void testContentFunction() {
        FunctionResult fr;
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_7 = null;
        try {
            fr = ExpressionLanguageParser.parse((String)"${ IntegerValue.Content }").evaluate((FunctionContext)context);
            try {
                ContentFunctionTests.assertNull((Object)fr.value());
                element.setIntegerValue(3);
                ContentFunctionTests.assertEquals((Object)3, (Object)fr.value());
                element.setIntegerValue("abc");
                ContentFunctionTests.assertNull((Object)fr.value());
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_7 = null;
        try {
            fr = ExpressionLanguageParser.parse((String)"${ IntegerValueWithDefault.Content }").evaluate((FunctionContext)context);
            try {
                ContentFunctionTests.assertEquals((Object)1, (Object)fr.value());
                element.setIntegerValueWithDefault(3);
                ContentFunctionTests.assertEquals((Object)3, (Object)fr.value());
                element.setIntegerValueWithDefault("abc");
                ContentFunctionTests.assertEquals((Object)1, (Object)fr.value());
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var4_7 = null;
        try {
            fr = ExpressionLanguageParser.parse((String)"${ Transient.Content }").evaluate((FunctionContext)context);
            try {
                ContentFunctionTests.assertNull((Object)fr.value());
                element.setTransient((Object)this);
                ContentFunctionTests.assertSame((Object)((Object)this), (Object)fr.value());
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testContentFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Content( null ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            ContentFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            ContentFunctionTests.assertEquals((Object)"Function Content does not accept nulls in position 0.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testContentFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Content( 'abc' ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            ContentFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            ContentFunctionTests.assertEquals((Object)"Function Content( java.lang.String ) is undefined.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

