/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.message;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.severity.TestElement;
import org.junit.Test;

public final class MessageFunctionTests
extends TestExpr {
    @Test
    public void testMessageFunction() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ IntegerValue.Validation.Message }").evaluate((FunctionContext)context);){
            MessageFunctionTests.assertEquals((Object)"ok", (Object)fr.value());
            element.setIntegerValue(3);
            MessageFunctionTests.assertEquals((Object)"ok", (Object)fr.value());
            element.setIntegerValue("abc");
            MessageFunctionTests.assertEquals((Object)"\"abc\" is not a valid integer", (Object)fr.value());
            element.setIntegerValue(4);
            MessageFunctionTests.assertEquals((Object)"ok", (Object)fr.value());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testMessageFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Message( null ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            MessageFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            MessageFunctionTests.assertEquals((Object)"Function Message does not accept nulls in position 0.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testMessageFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Message( 'abc' ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            MessageFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            MessageFunctionTests.assertEquals((Object)"Function Message( java.lang.String ) is undefined.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

