/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.size;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.size.TestElement;
import org.junit.Test;

public final class SizeFunctionTests
extends TestExpr {
    @Test
    public void testSizeFunctionOnList() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ List.Size }").evaluate((FunctionContext)context);){
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
            element.getList().insert();
            SizeFunctionTests.assertEquals((Object)1, (Object)fr.value());
            element.getList().insert();
            SizeFunctionTests.assertEquals((Object)2, (Object)fr.value());
            element.getList().clear();
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSizeFunctionOnValue() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Value.Size }").evaluate((FunctionContext)context);){
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
            element.setValue("abc");
            SizeFunctionTests.assertEquals((Object)3, (Object)fr.value());
            element.setValue(null);
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSizeFunctionOnString() {
        FunctionContext context = new FunctionContext();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Size( 'abcdef' ) }").evaluate(context);){
            SizeFunctionTests.assertEquals((Object)6, (Object)fr.value());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSizeFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Size( null ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            SizeFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            SizeFunctionTests.assertEquals((Object)"Function Size does not accept nulls in position 0.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSizeFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Size( 3 ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            SizeFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            SizeFunctionTests.assertEquals((Object)"Function Size cannot be applied to a java.math.BigInteger object.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

