/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.text;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.text.TestElement;
import org.junit.Test;

public final class TextFunctionTests
extends TestExpr {
    @Test
    public void testTextFunction() {
        FunctionResult fr;
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            fr = ExpressionLanguageParser.parse((String)"${ IntegerValue.Text }").evaluate((FunctionContext)context);
            try {
                TextFunctionTests.assertNull((Object)fr.value());
                element.setIntegerValue(3);
                TextFunctionTests.assertEquals((Object)"3", (Object)fr.value());
                element.setIntegerValue("abc");
                TextFunctionTests.assertEquals((Object)"abc", (Object)fr.value());
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            fr = ExpressionLanguageParser.parse((String)"${ IntegerValueWithDefault.Text }").evaluate((FunctionContext)context);
            try {
                TextFunctionTests.assertEquals((Object)"1", (Object)fr.value());
                element.setIntegerValueWithDefault(3);
                TextFunctionTests.assertEquals((Object)"3", (Object)fr.value());
                element.setIntegerValueWithDefault("abc");
                TextFunctionTests.assertEquals((Object)"abc", (Object)fr.value());
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testTextFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Text( null ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            TextFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            TextFunctionTests.assertEquals((Object)"Function Text does not accept nulls in position 0.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testTextFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Text( 'abc' ) }").evaluate((FunctionContext)context);){
            Status st = fr.status();
            TextFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            TextFunctionTests.assertEquals((Object)"Function Text( java.lang.String ) is undefined.", (Object)st.message());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

