/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.binding.t0009;

import java.nio.charset.StandardCharsets;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.ITestChildElementA;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.ITestChildElementB;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.ITestRootElement;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.TestChildElementA;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.TestChildElementB;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.TestRootElement;
import org.junit.Test;

public final class TestXmlBinding0009
extends SapphireTestCase {
    @Test
    public void testDefaultBindingWrite1() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestRootElement model = (TestRootElement)TestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        model.resource().setCorruptedResourceExceptionInterceptor(new CorruptedResourceExceptionInterceptor(){

            public boolean shouldAttemptRepair() {
                return true;
            }
        });
        model.setValuePropertyA("aaaa");
        model.setValuePropertyB("bbbb");
        TestChildElementA listChild1 = (TestChildElementA)model.getListPropertyA().insert(TestChildElementA.TYPE);
        listChild1.setValuePropertyA("cccc");
        TestChildElementB listChild2 = (TestChildElementB)model.getListPropertyA().insert(TestChildElementB.TYPE);
        listChild2.setValuePropertyB("dddd");
        TestChildElementA listChild3 = (TestChildElementA)model.getListPropertyA().insert(TestChildElementA.TYPE);
        listChild3.setValuePropertyA("eeee");
        TestChildElementB elementChild = (TestChildElementB)model.getElementPropertyA().content(true, TestChildElementB.TYPE);
        elementChild.setValuePropertyB("ffff");
        model.resource().save();
        String result = new String(resourceStore.getContents(), StandardCharsets.UTF_8);
        TestXmlBinding0009.assertEqualsIgnoreNewLineDiffs(this.loadResource("TestData.txt"), result);
    }

    @Test
    public void testDefaultBindingWrite2() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        ITestRootElement model = (ITestRootElement)ITestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        model.resource().setCorruptedResourceExceptionInterceptor(new CorruptedResourceExceptionInterceptor(){

            public boolean shouldAttemptRepair() {
                return true;
            }
        });
        model.setValuePropertyA("aaaa");
        model.setValuePropertyB("bbbb");
        ITestChildElementA listChild1 = (ITestChildElementA)model.getListPropertyA().insert(ITestChildElementA.TYPE);
        listChild1.setValuePropertyA("cccc");
        ITestChildElementB listChild2 = (ITestChildElementB)model.getListPropertyA().insert(ITestChildElementB.TYPE);
        listChild2.setValuePropertyB("dddd");
        ITestChildElementA listChild3 = (ITestChildElementA)model.getListPropertyA().insert(ITestChildElementA.TYPE);
        listChild3.setValuePropertyA("eeee");
        ITestChildElementB elementChild = (ITestChildElementB)model.getElementPropertyA().content(true, ITestChildElementB.TYPE);
        elementChild.setValuePropertyB("ffff");
        model.resource().save();
        String result = new String(resourceStore.getContents(), StandardCharsets.UTF_8);
        TestXmlBinding0009.assertEqualsIgnoreNewLineDiffs(this.loadResource("TestData.txt"), result);
    }

    @Test
    public void testDefaultBindingRead1() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore(this.loadResourceAsStream("TestData.txt"));
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestRootElement model = (TestRootElement)TestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        TestXmlBinding0009.assertEquals((Object)"aaaa", (Object)model.getValuePropertyA().text());
        TestXmlBinding0009.assertEquals((Object)"bbbb", (Object)model.getValuePropertyB().text());
        TestXmlBinding0009.assertEquals((long)3L, (long)model.getListPropertyA().size());
        TestXmlBinding0009.assertEquals((Object)"cccc", (Object)((TestChildElementA)model.getListPropertyA().get(0)).getValuePropertyA().text());
        TestXmlBinding0009.assertEquals((Object)"dddd", (Object)((TestChildElementB)model.getListPropertyA().get(1)).getValuePropertyB().text());
        TestXmlBinding0009.assertEquals((Object)"eeee", (Object)((TestChildElementA)model.getListPropertyA().get(2)).getValuePropertyA().text());
        TestXmlBinding0009.assertEquals((Object)"ffff", (Object)((TestChildElementB)model.getElementPropertyA().content(false)).getValuePropertyB().text());
    }

    @Test
    public void testDefaultBindingRead2() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore(this.loadResourceAsStream("TestData.txt"));
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        ITestRootElement model = (ITestRootElement)ITestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        TestXmlBinding0009.assertEquals((Object)"aaaa", (Object)model.getValuePropertyA().text());
        TestXmlBinding0009.assertEquals((Object)"bbbb", (Object)model.getValuePropertyB().text());
        TestXmlBinding0009.assertEquals((long)3L, (long)model.getListPropertyA().size());
        TestXmlBinding0009.assertEquals((Object)"cccc", (Object)((ITestChildElementA)model.getListPropertyA().get(0)).getValuePropertyA().text());
        TestXmlBinding0009.assertEquals((Object)"dddd", (Object)((ITestChildElementB)model.getListPropertyA().get(1)).getValuePropertyB().text());
        TestXmlBinding0009.assertEquals((Object)"eeee", (Object)((ITestChildElementA)model.getListPropertyA().get(2)).getValuePropertyA().text());
        TestXmlBinding0009.assertEquals((Object)"ffff", (Object)((ITestChildElementB)model.getElementPropertyA().content(false)).getValuePropertyB().text());
    }
}

