/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.possible;

import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.possible.ListEntry;
import org.eclipse.sapphire.tests.possible.TestElement;
import org.junit.Test;

public final class PossibleValuesTest
extends SapphireTestCase {
    @Test
    public void testValueWithStaticPossibles() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            PossibleValuesService service = (PossibleValuesService)element.getValueWithStaticPossibles().service(PossibleValuesService.class);
            PossibleValuesTest.assertNotNull((Object)service);
            PossibleValuesTest.assertEquals(PossibleValuesTest.set("a", "b", "c"), (Object)service.values());
            PossibleValuesTest.assertValidationOk(element.getValueWithStaticPossibles());
            element.setValueWithStaticPossibles("a");
            PossibleValuesTest.assertValidationOk(element.getValueWithStaticPossibles());
            element.setValueWithStaticPossibles("d");
            PossibleValuesTest.assertValidationError(element.getValueWithStaticPossibles(), "\"d\" is not among possible values");
            element.setValueWithStaticPossibles("b");
            PossibleValuesTest.assertValidationOk(element.getValueWithStaticPossibles());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testValueWithModelPossibles() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ListEntry a = (ListEntry)element.getEntries().insert();
            a.setValue("a");
            ListEntry b = (ListEntry)element.getEntries().insert();
            b.setValue("b");
            ListEntry c = (ListEntry)element.getEntries().insert();
            c.setValue("c");
            PossibleValuesService service = (PossibleValuesService)element.getValueWithModelPossibles().service(PossibleValuesService.class);
            PossibleValuesTest.assertNotNull((Object)service);
            PossibleValuesTest.assertEquals(PossibleValuesTest.set("a", "b", "c"), (Object)service.values());
            PossibleValuesTest.assertValidationOk(element.getValueWithModelPossibles());
            element.setValueWithModelPossibles("a");
            PossibleValuesTest.assertValidationOk(element.getValueWithModelPossibles());
            element.setValueWithModelPossibles("d");
            PossibleValuesTest.assertValidationError(element.getValueWithModelPossibles(), "\"d\" is not among possible values");
            element.setValueWithModelPossibles("b");
            PossibleValuesTest.assertValidationOk(element.getValueWithModelPossibles());
            b.setValue("d");
            PossibleValuesTest.assertValidationError(element.getValueWithModelPossibles(), "\"b\" is not among possible values");
            ((ListEntry)element.getEntries().insert()).setValue("b");
            PossibleValuesTest.assertValidationOk(element.getValueWithModelPossibles());
            PossibleValuesTest.assertEquals(PossibleValuesTest.set("a", "b", "c", "d"), (Object)service.values());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testListWithStaticPossibles() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            PossibleValuesService service = (PossibleValuesService)element.getListWithStaticPossibles().service(PossibleValuesService.class);
            PossibleValuesTest.assertNotNull((Object)service);
            PossibleValuesTest.assertEquals(PossibleValuesTest.set("a", "b", "c"), (Object)service.values());
            ListEntry entry = (ListEntry)element.getListWithStaticPossibles().insert();
            PossibleValuesTest.assertValidationOk(entry.getValue());
            entry.setValue("a");
            PossibleValuesTest.assertValidationOk(entry.getValue());
            entry.setValue("d");
            PossibleValuesTest.assertValidationError(entry.getValue(), "\"d\" is not among possible values");
            entry.setValue("b");
            PossibleValuesTest.assertValidationOk(entry.getValue());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testListWithModelPossibles() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ListEntry a = (ListEntry)element.getEntries().insert();
            a.setValue("a");
            ListEntry b = (ListEntry)element.getEntries().insert();
            b.setValue("b");
            ListEntry c = (ListEntry)element.getEntries().insert();
            c.setValue("c");
            PossibleValuesService service = (PossibleValuesService)element.getListWithModelPossibles().service(PossibleValuesService.class);
            PossibleValuesTest.assertNotNull((Object)service);
            PossibleValuesTest.assertEquals(PossibleValuesTest.set("a", "b", "c"), (Object)service.values());
            ListEntry entry = (ListEntry)element.getListWithModelPossibles().insert();
            PossibleValuesTest.assertValidationOk(entry.getValue());
            entry.setValue("a");
            PossibleValuesTest.assertValidationOk(entry.getValue());
            entry.setValue("d");
            PossibleValuesTest.assertValidationError(entry.getValue(), "\"d\" is not among possible values");
            entry.setValue("b");
            PossibleValuesTest.assertValidationOk(entry.getValue());
            b.setValue("d");
            PossibleValuesTest.assertValidationError(entry.getValue(), "\"b\" is not among possible values");
            ((ListEntry)element.getEntries().insert()).setValue("b");
            PossibleValuesTest.assertValidationOk(entry.getValue());
            PossibleValuesTest.assertEquals(PossibleValuesTest.set("a", "b", "c", "d"), (Object)service.values());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

