/********************************************************************************
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Initial Contributor:
 * Fabio Rigo
 *
 * Contributors:
 * Daniel Barboza Franco (Motorola) - Bug [233775] - Does not have a way to enter the session password for the vnc connection
 * Fabio Fantato (Eldorado Research Institute - Bug [243305] - The plugin org.eclipse.tml.echo has compilation errors about exception handling mechanism
 * Fabio Rigo (Eldorado Research Institute) - [246212] - Enhance encapsulation of protocol implementer 
 ********************************************************************************/
package org.eclipse.tml.echo;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolInitException;

public class EchoProtocolInit implements IProtocolInit {

	public void serverInit(ProtocolHandle handle, DataInputStream in,
			OutputStream out, Map parameters) throws ProtocolInitException {

		try {
			byte[] buff = new byte[20];
			int read = in.read(buff, 0, 20);

			if ((read != 13)
					|| (!(new String(buff).trim()).equals("Hello server!"))) {
				System.out.println("ERROR");
				throw new ProtocolInitException();
			} else {
				out.write(new String("Hello client.").getBytes());
			}

		} catch (IOException e) {
			throw new ProtocolInitException();
		}
	}

	public void clientInit(ProtocolHandle handle, DataInputStream in,
			OutputStream out, Map parameters) throws ProtocolInitException {

		try {
			out.write(new String("Hello server!").getBytes());
			byte[] buff = new byte[20];
			int read = in.read(buff, 0, 20);

			if ((read != 13)
					|| (!(new String(buff).trim()).equals("Hello client."))) {
				System.out.println("ERROR");
				throw new ProtocolInitException();
			}

		} catch (IOException e) {
			throw new ProtocolInitException();
		}
	}
}
