/********************************************************************************
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Initial Contributor:
 * Fabio Rigo
 *
 * Contributors:
 * Fabio Fantato (Eldorado Research Institute - Bug [243305] - The plugin org.eclipse.tml.echo has compilation errors about exception handling mechanism
 * Fabio Rigo (Eldorado Research Institute) - [246212] - Enhance encapsulation of protocol implementer
 ********************************************************************************/
package org.eclipse.tml.echo;

import org.eclipse.tml.protocol.lib.IMessageHandler;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;

public class ResponseHandler implements IMessageHandler {

	public ProtocolMessage handleMessage(ProtocolHandle handle,
			ProtocolMessage message) {

		String echoedMessage = (String) message.getFieldValue("echoedMessage");

		System.out.println("Client has received the echoed message \""
				+ echoedMessage + "\"");

		Object sizeObj = message.getFieldValue("echoedMessageSize");
		if (sizeObj != null)
		{
			Integer size = new Integer((String)sizeObj);
			System.out.println("Size is present in message which code is " + message.getCode() + ". Its value is " + size.intValue());
		}
		else
		{
			System.out.println("Size is NOT present in message which code is " + message.getCode());
		}
		
		return null;
	}
}
