/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt.img;

import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tml.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.tml.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.tml.vncviewer.graphics.swt.img.Painter;
import org.eclipse.tml.vncviewer.network.IVNCPainter;

public class SWTRemoteDisplayImg
extends SWTRemoteDisplay {
    public SWTRemoteDisplayImg(Composite parent, Properties configProperties, IPropertiesFileHandler propertiesFileHandler) {
        super(parent, configProperties, propertiesFileHandler);
        this.painter = new Painter(this);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SWTRemoteDisplayImg.this.paintControl(e);
            }
        });
    }

    protected int getCanvasStyle() {
        return 262144;
    }

    public IVNCPainter getPainter() {
        return (Painter)this.painter;
    }

    protected void redrawScreen() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas c = SWTRemoteDisplayImg.this.getCanvas();
                if (c != null && !c.isDisposed()) {
                    c.redraw();
                }
            }
        });
    }

    protected void redrawScreen(int x, int y, int width, int height) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas c = SWTRemoteDisplayImg.this.getCanvas();
                if (c != null && !c.isDisposed()) {
                    c.redraw(x, y, width, height, false);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.painter != null) {
            ((Painter)this.painter).dispose();
        }
    }

    protected void paintControl(PaintEvent event) {
        ImageData id = this.painter != null ? ((Painter)this.painter).getImageData() : null;
        Image image = null;
        if (id != null) {
            id = id.scaledTo((int)((double)id.width * this.getZoomFactor()), (int)((double)id.height * this.getZoomFactor()));
            image = new Image(event.gc.getDevice(), id);
        }
        event.gc.setBackground(this.canvas.getBackground());
        event.gc.setForeground(this.canvas.getForeground());
        if (image == null) {
            event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        } else {
            Rectangle r = image.getBounds();
            int w = Math.min(event.width, r.width);
            int h = Math.min(event.height, r.height);
            event.gc.drawImage(image, event.x, event.y, w, h, event.x, event.y, w, h);
            image.dispose();
        }
    }
}

