/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import java.io.DataInputStream;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolException;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;

public class PixelFormat {
    private int bitsPerPixel;
    private int depth;
    private int bigEndianFlag;
    private int trueColourFlag;
    private int redMax;
    private int greenMax;
    private int blueMax;
    private int redShift;
    private int greenShift;
    private int blueShift;
    private static int paddingSize = 3;

    public void getPixelFormat(DataInputStream in) throws ProtocolException {
        try {
            this.bitsPerPixel = in.readUnsignedByte();
            this.depth = in.readUnsignedByte();
            this.bigEndianFlag = in.readUnsignedByte();
            this.trueColourFlag = in.readUnsignedByte();
            this.redMax = in.readUnsignedShort();
            this.greenMax = in.readUnsignedShort();
            this.blueMax = in.readUnsignedShort();
            this.redShift = in.readUnsignedByte();
            this.greenShift = in.readUnsignedByte();
            this.blueShift = in.readUnsignedByte();
            byte[] padding = new byte[paddingSize];
            in.readFully(padding);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(PixelFormat.class).error("Pixel Format read error: " + e.getMessage());
            throw new ProtocolException("Pixel Format read error.");
        }
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getBigEndianFlag() {
        return this.bigEndianFlag;
    }

    public int getTrueColourFlag() {
        return this.trueColourFlag;
    }

    public int getRedMax() {
        return this.redMax;
    }

    public int getGreenMax() {
        return this.greenMax;
    }

    public int getBlueMax() {
        return this.blueMax;
    }

    public int getRedShift() {
        return this.redShift;
    }

    public int getGreenShift() {
        return this.greenShift;
    }

    public int getBlueShift() {
        return this.blueShift;
    }
}

