/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.IDeviceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileDevice
implements IDevice {
    private String id;
    private String name;
    private ImageDescriptor image;
    private String copyright;
    private String description;
    private String provider;
    private String version;
    private IDeviceHandler handler;
    private List<IService> services;
    private IInstance parent;
    private Properties properties;

    public MobileDevice(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.image;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public IDeviceHandler getHandler() {
        return this.handler;
    }

    @Override
    public List<IService> getServices() {
        return this.services;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setImage(ImageDescriptor image) {
        this.image = image;
    }

    @Override
    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setHandler(IDeviceHandler handler) {
        this.handler = handler;
    }

    @Override
    public void setServices(List<IService> services) {
        this.services = services;
        for (IService service : services) {
            service.setParent(this);
        }
    }

    @Override
    public IInstance getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IInstance instance) {
        this.parent = instance;
    }

    @Override
    public Object clone() {
        MobileDevice newDevice = new MobileDevice(this.id);
        newDevice.setName(this.name);
        newDevice.setImage(this.image);
        newDevice.setCopyright(this.copyright);
        newDevice.setDescription(this.description);
        newDevice.setProvider(this.provider);
        newDevice.setVersion(this.version);
        newDevice.setHandler(this.handler);
        if (this.services != null) {
            ArrayList<IService> cServices = new ArrayList<IService>();
            for (IService service : this.services) {
                cServices.add((IService)service.clone());
            }
            newDevice.setServices(cServices);
        }
        return newDevice;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.properties;
    }

    @Override
    public void setDefaultProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "[Device: id=" + (this.id == null ? "" : this.id) + ",name=" + (this.name == null ? "" : this.name) + ",description=" + (this.description == null ? "" : this.description) + ",version=" + (this.version == null ? "" : this.version) + ",provider=" + (this.provider == null ? "" : this.provider) + ",copyright=" + (this.copyright == null ? "" : this.copyright) + ",handler=" + (this.handler == null ? "" : this.handler.getClass().getName()) + "]";
    }
}

