/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolInitException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.protocol.lib.internal.model.ClientModel;
import org.eclipse.tml.protocol.lib.internal.model.ServerModel;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolActionDelegate {
    public static ProtocolHandle startClientProtocol(Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolInit protocolInitializer, IProtocolExceptionHandler exceptionHandler, Boolean isBigEndianProtocol, String host, int port, Map<String, Object> parameters) throws UnknownHostException, IOException, ProtocolInitException {
        ClientModel model = ClientModel.getInstance();
        return model.startClientProtocol(allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol, host, port, parameters);
    }

    public static ProtocolHandle startServerProtocol(int portToBind, Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolInit protocolInitializer, IProtocolExceptionHandler exceptionHandler, boolean isBigEndianProtocol) throws IOException, ProtocolInitException {
        ServerModel model = ServerModel.getInstance();
        return model.startListeningToPort(portToBind, allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol);
    }

    public static void stopProtocol(ProtocolHandle handle) throws IOException {
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.stopClientProtocol(handle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.stopListeningToPort(handle);
    }

    public static void restartProtocol(ProtocolHandle handle) throws IOException, ProtocolInitException, ProtocolException {
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.restartClientProtocol(handle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.restartServerProtocol(handle);
    }

    public static void sendMessageToServer(ProtocolHandle handle, ProtocolMessage message) throws IOException, ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException {
        ClientModel model = ClientModel.getInstance();
        model.sendMessage(handle, message);
    }
}

