/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.vncviews.views;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tml.protocol.PluginProtocolActionDelegate;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.graphics.RemoteDisplayFactory;
import org.eclipse.tml.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.tml.vncviewer.network.VNCProtocolExceptionHandler;
import org.eclipse.tml.vncviewer.vncviews.views.ProtocolIdTranslator;
import org.eclipse.ui.part.ViewPart;

public class VNCViewerView
extends ViewPart {
    private static final String VIEWER_COULD_NOT_BE_STARTED = "Viewer could not be started: ";
    private static final String SWTDISPLAY = "SWTDisplay";
    private static SWTRemoteDisplay swtDisplay;
    private static boolean running;
    public static ProtocolHandle protocolHandle;
    private static int zoomFactor;

    static {
        running = false;
        zoomFactor = 1;
    }

    public void createPartControl(Composite parent) {
        swtDisplay = (SWTRemoteDisplay)RemoteDisplayFactory.getDisplay((String)SWTDISPLAY, (Composite)parent);
        running = true;
        if (protocolHandle != null) {
            try {
                swtDisplay.start(protocolHandle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFocus() {
        if (swtDisplay != null) {
            swtDisplay.setFocus();
        }
    }

    public void dispose() {
        running = false;
        if (swtDisplay != null) {
            swtDisplay.dispose();
        }
        super.dispose();
    }

    public static synchronized void start(String host, int port, String protoVersion, String password, boolean bypassProxy) {
        if (running && swtDisplay != null) {
            if (swtDisplay.isActive()) {
                swtDisplay.stop();
            }
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                String protocolId = ProtocolIdTranslator.getProtocolId(protoVersion);
                parameters.put("password", password);
                parameters.put("connectionRetries", swtDisplay.getConnectionRetries());
                parameters.put("bypassProxy", new Boolean(bypassProxy));
                protocolHandle = PluginProtocolActionDelegate.startClientProtocol((String)protocolId, (IProtocolExceptionHandler)new VNCProtocolExceptionHandler(), (String)host, (int)port, parameters);
                swtDisplay.start(protocolHandle);
            }
            catch (Exception e) {
                VNCViewerPlugin.log(VNCViewerView.class).error((Object)(VIEWER_COULD_NOT_BE_STARTED + e.getMessage()));
                GC gc = new GC((Drawable)swtDisplay.getCanvas());
                gc.fillRectangle(0, 0, swtDisplay.getScreenWidth(), swtDisplay.getScreenHeight());
                gc.dispose();
            }
        }
    }

    public static synchronized void stop() {
        if (running && swtDisplay != null && swtDisplay.isActive()) {
            swtDisplay.getDisplay().syncExec(new Runnable(){

                public void run() {
                    swtDisplay.stop();
                }
            });
        }
    }

    public static void zoomIn() {
        double newzoom = 1.0;
        zoomFactor = zoomFactor == -2 ? 1 : ++zoomFactor;
        newzoom = zoomFactor >= 1 ? (double)zoomFactor : 1.0 / (double)(-zoomFactor);
        swtDisplay.setZoomFactor(newzoom);
        try {
            swtDisplay.updateRequest(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zoomOut() {
        double newzoom = 1.0;
        zoomFactor = zoomFactor == 1 ? -2 : --zoomFactor;
        newzoom = zoomFactor >= 1 ? (double)zoomFactor : 1.0 / (double)(-zoomFactor);
        swtDisplay.setZoomFactor(newzoom);
        try {
            swtDisplay.updateRequest(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopProtocol() throws IOException {
        if (protocolHandle != null) {
            PluginProtocolActionDelegate.stopProtocol((ProtocolHandle)protocolHandle);
        }
    }
}

