/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tml.protocol.lib.IMessageFieldsStore;
import org.eclipse.tml.protocol.lib.IRawDataHandler;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.RectHeader;
import org.eclipse.tml.vncviewer.network.VNCProtocolData;
import org.eclipse.tml.vncviewer.registry.VNCProtocolRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FramebufferRectanglesHandler
implements IRawDataHandler {
    private int current_rect = 1;
    private int x0;
    private int y0 = Integer.MAX_VALUE;
    private int x1;
    private int y1 = 0;

    public Map<String, Object> readRawDataFromStream(ProtocolHandle handle, InputStream dataStream, IMessageFieldsStore currentlyReadFields, boolean isBigEndian) throws IOException, ProtocolRawHandlingException {
        int w = (Integer)currentlyReadFields.getFieldValue("width");
        int h = (Integer)currentlyReadFields.getFieldValue("height");
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        VNCProtocolData protocolData = VNCProtocolRegistry.getInstance().get(handle);
        if (protocolData != null) {
            IVNCPainter painter = protocolData.getVncPainter();
            int x = (Integer)currentlyReadFields.getFieldValue("x-position");
            int y = (Integer)currentlyReadFields.getFieldValue("y-position");
            int width = (Integer)currentlyReadFields.getFieldValue("width");
            int height = (Integer)currentlyReadFields.getFieldValue("height");
            int encoding = (Integer)currentlyReadFields.getFieldValue("encodingType");
            try {
                painter.processRectangle(new RectHeader(x, y, width, height, encoding), protocolData.getInputStream());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int numRect = (Integer)currentlyReadFields.getFieldValue("numberOfRectangles");
            this.x0 = Math.min(this.x0, x);
            this.y0 = Math.min(this.y0, y);
            this.x1 = Math.max(this.x1, x + w);
            this.y1 = Math.max(this.y1, y + h);
            if (this.current_rect == numRect) {
                this.current_rect = 1;
                painter.updateRectangle(this.x0, this.y0, this.x1, this.y1);
                this.y0 = Integer.MAX_VALUE;
                this.x0 = Integer.MAX_VALUE;
                this.y1 = 0;
                this.x1 = 0;
            } else {
                ++this.current_rect;
            }
        }
        return fieldsMap;
    }

    public void writeRawDataToStream(ProtocolHandle handle, ByteArrayOutputStream dataStream, ProtocolMessage messageToGetInformationFrom, boolean isBigEndian) throws ProtocolRawHandlingException {
    }
}

