/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.tml.vncviewer.graphics.AbstractPaintStrategy;
import org.eclipse.tml.vncviewer.graphics.IPainterContext;
import org.eclipse.tml.vncviewer.network.PixelFormat;
import org.eclipse.tml.vncviewer.network.RectHeader;

public class ZRLEPaintStrategy
extends AbstractPaintStrategy {
    private MemoryBlockInputStream memoryBlockStream = new MemoryBlockInputStream();
    private DataInputStream zlibStream = null;

    public ZRLEPaintStrategy(IPainterContext context) {
        super(context);
    }

    protected int getBytesPerCPixel() {
        int result = 0;
        PixelFormat pixelFormat = this.getContext().getPixelFormat();
        result = pixelFormat.getTrueColourFlag() != 0 && pixelFormat.getBitsPerPixel() == 32 && pixelFormat.getDepth() <= 24 ? 3 : this.getContext().getBytesPerPixel();
        return result;
    }

    public void processRectangle(RectHeader rh, DataInputStream in) throws Exception {
        int x = rh.getX();
        int y = rh.getY();
        int width = rh.getWidth();
        int height = rh.getHeight();
        DataInputStream zlibInputStream = this.getZlibInputStream();
        this.memoryBlockStream.readBlock(in);
        int[] tilePixels = new int[4096];
        int tileY = y;
        while (tileY < y + height) {
            int tileHeight = Math.min(y + height - tileY, 64);
            int tileX = x;
            while (tileX < x + width) {
                int tileWidth = Math.min(x + width - tileX, 64);
                int mode = zlibInputStream.readUnsignedByte();
                boolean rle = (mode & 0x80) != 0;
                int palSize = mode & 0x7F;
                int[] palette = new int[128];
                this.readZrlePalette(zlibInputStream, palette, palSize);
                if (palSize == 1) {
                    int pix = palette[0];
                    this.getContext().fillRect(pix, tileX, tileY, tileWidth, tileHeight);
                } else {
                    if (!rle) {
                        if (palSize == 0) {
                            this.readZrleRawPixels(zlibInputStream, tilePixels, tileWidth, tileHeight);
                        } else {
                            this.readZrlePackedPixels(zlibInputStream, tilePixels, tileWidth, tileHeight, palette, palSize);
                        }
                    } else if (palSize == 0) {
                        this.readZrlePlainRLEPixels(zlibInputStream, tilePixels, tileWidth, tileHeight);
                    } else {
                        this.readZrlePackedRLEPixels(zlibInputStream, tilePixels, tileWidth, tileHeight, palette);
                    }
                    this.processUpdatedZrleTile(tilePixels, tileX, tileY, tileWidth, tileHeight);
                }
                tileX += 64;
            }
            tileY += 64;
        }
    }

    void readZrlePalette(DataInputStream zrleInStream, int[] palette, int palSize) throws Exception {
        this.readPixels(zrleInStream, palette, palSize);
    }

    void readZrleRawPixels(DataInputStream zrleInStream, int[] tilePixels, int tw, int th) throws Exception {
        this.readPixels(zrleInStream, tilePixels, tw * th);
    }

    void readZrlePackedPixels(DataInputStream zrleInStream, int[] tilePixels, int tw, int th, int[] palette, int palSize) throws Exception {
        int bppp = palSize > 16 ? 8 : (palSize > 4 ? 4 : (palSize > 2 ? 2 : 1));
        int ptr = 0;
        int i = 0;
        while (i < th) {
            int eol = ptr + tw;
            int b = 0;
            int nbits = 0;
            while (ptr < eol) {
                if (nbits == 0) {
                    b = zrleInStream.readUnsignedByte();
                    nbits = 8;
                }
                int index = b >> (nbits -= bppp) & (1 << bppp) - 1 & 0x7F;
                tilePixels[ptr++] = palette[index];
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    void readZrlePlainRLEPixels(DataInputStream zrleInStream, int[] tilePixels, int tw, int th) throws Exception {
        ptr = 0;
        end = ptr + tw * th;
        while (ptr < end) {
            pix = this.readPixel(zrleInStream);
            len = 1;
            do {
                b = zrleInStream.readUnsignedByte();
                len += b;
            } while (b == 255);
            if (len <= end - ptr) ** GOTO lbl13
            throw new Exception("ZRLE decoder: assertion failed (len <= end-ptr)");
lbl-1000:
            // 1 sources

            {
                tilePixels[ptr++] = pix;
lbl13:
                // 2 sources

                ** while (len-- > 0)
            }
lbl14:
            // 1 sources

        }
    }

    void readZrlePackedRLEPixels(DataInputStream zrleInStream, int[] tilePixels, int tw, int th, int[] palette) throws Exception {
        int ptr = 0;
        int end = ptr + tw * th;
        while (ptr < end) {
            int index = zrleInStream.readUnsignedByte();
            int len = 1;
            if ((index & 0x80) != 0) {
                int b;
                do {
                    b = zrleInStream.readUnsignedByte();
                    len += b;
                } while (b == 255);
                if (len > end - ptr) {
                    throw new Exception("ZRLE decoder: assertion failed (len <= end - ptr)");
                }
            }
            int pix = palette[index &= 0x7F];
            while (len-- > 0) {
                tilePixels[ptr++] = pix;
            }
        }
    }

    void readPixels(DataInputStream is, int[] dst, int count) throws Exception {
        int bytesPerCPixel = this.getBytesPerCPixel();
        IPainterContext pc = this.getContext();
        int i = 0;
        while (i < count) {
            dst[i] = pc.readPixel(is, bytesPerCPixel);
            ++i;
        }
    }

    int readPixel(DataInputStream is) throws Exception {
        return this.getContext().readPixel(is, this.getBytesPerCPixel());
    }

    void processUpdatedZrleTile(int[] tilePixels, int x, int y, int width, int height) {
        this.getContext().setPixels(x, y, width, height, tilePixels, 0);
    }

    private DataInputStream getZlibInputStream() {
        if (this.zlibStream == null) {
            this.zlibStream = new DataInputStream(new InflaterInputStream(this.memoryBlockStream, new Inflater(), 16384));
        }
        return this.zlibStream;
    }

    protected static class MemoryBlockInputStream
    extends InputStream {
        protected byte[] buffer;
        protected int bufferLength;
        int pointer = 0;

        protected MemoryBlockInputStream() {
        }

        public int read() throws IOException {
            if (this.buffer != null) {
                if (this.pointer < this.bufferLength) {
                    return this.buffer[this.pointer++] & 0xFF;
                }
                return -1;
            }
            throw new IOException("EOF");
        }

        public void readBlock(DataInputStream in) throws Exception {
            int n = in.readInt();
            if (this.buffer == null || this.buffer.length < n) {
                this.buffer = new byte[n];
            }
            in.readFully(this.buffer, 0, n);
            this.bufferLength = n;
            this.pointer = 0;
        }

        public int available() throws IOException {
            if (this.buffer != null) {
                return this.bufferLength - this.pointer;
            }
            return 0;
        }
    }
}

