/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.engine;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.tml.protocol.lib.IMessageHandler;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolInit;
import org.eclipse.tml.protocol.lib.IRawDataHandler;
import org.eclipse.tml.protocol.lib.MessageFieldsStore;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidInputStreamDataException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.tml.protocol.lib.exceptions.MessageHandleException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolInitException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.protocol.lib.internal.model.ClientModel;
import org.eclipse.tml.protocol.lib.internal.model.IModel;
import org.eclipse.tml.protocol.lib.internal.model.ServerModel;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;
import org.eclipse.tml.protocol.lib.msgdef.databeans.FixedSizeDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.IMsgDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.IteratableBlockDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.RawDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.VariableSizeDataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolEngine {
    private static final int RECONNECTION_MAX = 5;
    private boolean isBigEndianProtocol;
    private ProtocolHandle handle;
    private Map<Long, ProtocolMsgDefinition> messageDefCollection;
    private int retries;
    private int retriesMax = 5;
    private int connectionSerialNumber = 0;
    private Collection<String> incomingMessages;
    private Collection<String> outgoingMessages;
    private IProtocolInit initProcedure;
    private IProtocolExceptionHandler exceptionHandler;
    private Socket socket;
    private String host;
    private Map parameters;
    private int port;
    private boolean isServer;
    private DataInputStream in;
    private OutputStream out;
    private Consumer consumer;

    public ProtocolEngine(ProtocolHandle handle, IProtocolInit initProcedure, Map<Long, ProtocolMsgDefinition> messageDefCollection, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolExceptionHandler exceptionHandler, boolean isBigEndianProtocol, boolean isServer, int retries) {
        this.handle = handle;
        this.initProcedure = initProcedure;
        this.messageDefCollection = messageDefCollection;
        this.incomingMessages = incomingMessages;
        this.outgoingMessages = outgoingMessages;
        this.exceptionHandler = exceptionHandler;
        this.isBigEndianProtocol = isBigEndianProtocol;
        this.isServer = isServer;
        this.retries = this.retriesMax = retries >= 0 ? retries : 5;
    }

    public synchronized void startProtocol(String host, int port, Map parameters) throws UnknownHostException, IOException, ProtocolInitException {
        this.startProtocol(host, port, parameters, -1);
    }

    public synchronized void startProtocol(String host, int port, Map parameters, int timeout) throws UnknownHostException, IOException, ProtocolInitException {
        this.host = host;
        this.port = port;
        this.parameters = parameters;
        Boolean bypassProxy = (Boolean)parameters.get("bypassProxy");
        bypassProxy = bypassProxy != null ? bypassProxy : new Boolean(false);
        Proxy proxy = (Proxy)parameters.get("proxy");
        this.socket = bypassProxy != false ? new Socket(Proxy.NO_PROXY) : (proxy != null ? new Socket(proxy) : new Socket());
        InetSocketAddress socketAdress = new InetSocketAddress(host, port);
        if (timeout < 0) {
            this.socket.connect(socketAdress);
        } else {
            this.socket.connect(socketAdress, timeout);
        }
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
        this.doStartProtocol();
    }

    public synchronized void startProtocol(Socket connectedSocket, Map parameters) throws IOException, ProtocolInitException {
        this.socket = connectedSocket;
        this.host = this.socket.getInetAddress().getHostAddress();
        this.port = this.socket.getPort();
        this.parameters = parameters;
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
        this.doStartProtocol();
    }

    private void doStartProtocol() throws ProtocolInitException {
        if (this.initProcedure != null) {
            if (this.isServer) {
                this.initProcedure.serverInit(this.handle, this.in, this.out, this.parameters);
            } else {
                this.initProcedure.clientInit(this.handle, this.in, this.out, this.parameters);
            }
            this.consumer = new Consumer();
            Thread consumerThread = new Thread(this.consumer);
            consumerThread.start();
            this.retries = this.retriesMax;
            ++this.connectionSerialNumber;
        }
    }

    public synchronized void stopProtocol() throws IOException {
        this.consumer.stopConsumer();
        this.out.close();
        this.in.close();
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(int serialNumber) throws UnknownHostException, ProtocolInitException, IOException, ProtocolException {
        if (this.connectionSerialNumber == serialNumber) {
            if (this.retries > 0) {
                try {
                    ProtocolEngine protocolEngine = this;
                    synchronized (protocolEngine) {
                        --this.retries;
                        this.restartProtocol();
                    }
                }
                catch (Exception exception) {
                    this.reconnect(serialNumber);
                }
            } else {
                throw new ProtocolException("Number of connection retries exceeded the limit of " + this.retriesMax + ".");
            }
        }
    }

    public void restartProtocol() throws UnknownHostException, IOException, ProtocolInitException, ProtocolException {
        if (this.isConnected()) {
            this.stopProtocol();
        }
        this.startProtocol(this.host, this.port, this.parameters);
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this.socket != null && this.socket.isConnected() && !this.socket.isClosed()) {
            isConnected = true;
        }
        return isConnected;
    }

    public final synchronized void sendMessage(ProtocolMessage message) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException, IOException {
        if (this.isConnected()) {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ProtocolMsgDefinition msgDefinition = this.messageDefCollection.get(message.getCode());
            if (msgDefinition != null && this.isOutgoingMessage(msgDefinition.getId())) {
                boolean isCodeSigned = msgDefinition.isMsgCodeSigned();
                int codeSize = msgDefinition.getMsgCodeSizeInBytes();
                this.writeNumberToStream(byteOutputStream, new Long(message.getCode()), codeSize, isCodeSigned);
                List<IMsgDataBean> msgDataList = msgDefinition.getMessageData();
                for (IMsgDataBean messageData : msgDataList) {
                    this.writeFilterMessageDef(messageData, byteOutputStream, message, null, -1);
                }
                try {
                    if (this.out != null) {
                        byteOutputStream.writeTo(this.out);
                        this.out.flush();
                    }
                }
                catch (IOException e) {
                    try {
                        this.reconnect(this.connectionSerialNumber);
                    }
                    catch (ProtocolException protocolException) {
                        this.handleIOExceptionOnStream();
                        throw e;
                    }
                }
            }
        }
    }

    private void writeFilterMessageDef(IMsgDataBean messageDataDef, ByteArrayOutputStream streamToWriteTo, ProtocolMessage message, String iteratableBlockId, int index) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException {
        if (messageDataDef instanceof FixedSizeDataBean) {
            this.writeFixedSizeDataToStream(streamToWriteTo, (FixedSizeDataBean)messageDataDef, message);
        } else if (messageDataDef instanceof VariableSizeDataBean) {
            this.writeVariableSizeDataToStream(streamToWriteTo, (VariableSizeDataBean)messageDataDef, message);
        } else if (messageDataDef instanceof RawDataBean) {
            this.writeRawDataToStream(streamToWriteTo, (RawDataBean)messageDataDef, message);
        } else {
            this.writeIteratableBlockToStream(streamToWriteTo, (IteratableBlockDataBean)messageDataDef, message);
        }
    }

    private void writeFixedSizeDataToStream(ByteArrayOutputStream streamToWriteTo, FixedSizeDataBean messageDataDef, ProtocolMessage message) throws InvalidMessageException, InvalidDefinitionException {
        String fieldName = messageDataDef.getFieldName();
        boolean isSigned = messageDataDef.isFieldSigned();
        int fieldSize = messageDataDef.getFieldSizeInBytes();
        Object value = messageDataDef.getValue();
        if (fieldName != null) {
            if (value == null) {
                value = message.getFieldValue(fieldName);
            }
            if (!(value instanceof Number)) {
                throw new InvalidMessageException("Field does not contain a number");
            }
        } else {
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
        this.writeNumberToStream(streamToWriteTo, (Number)value, fieldSize, isSigned);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeVariableSizeDataToStream(ByteArrayOutputStream streamToWriteTo, VariableSizeDataBean messageDataDef, ProtocolMessage message) throws InvalidMessageException, InvalidDefinitionException {
        boolean isSizeSigned = messageDataDef.isSizeFieldSigned();
        int sizeFieldSize = messageDataDef.getSizeFieldSizeInBytes();
        String valueFieldName = messageDataDef.getValueFieldName();
        String charsetName = messageDataDef.getCharsetName();
        Object value = messageDataDef.getValue();
        if (valueFieldName == null) throw new InvalidDefinitionException("Incomplete fixed data element");
        if (value == null) {
            value = message.getFieldValue(valueFieldName);
        }
        if (!(value instanceof String)) throw new InvalidMessageException("Value field does not contain a string");
        try {
            byte[] valueBytes = ((String)value).getBytes(charsetName);
            int valueBytesSize = valueBytes.length;
            this.writeNumberToStream(streamToWriteTo, valueBytesSize, sizeFieldSize, isSizeSigned);
            streamToWriteTo.write(valueBytes, 0, valueBytes.length);
            return;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidDefinitionException("Invalid charset name provided at message definition", e);
        }
    }

    private void writeRawDataToStream(ByteArrayOutputStream streamToWriteTo, RawDataBean messageDataDef, ProtocolMessage message) throws ProtocolRawHandlingException {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        IRawDataHandler handler = messageDataDef.getHandler();
        handler.writeRawDataToStream(this.handle, tempStream, message, this.isBigEndianProtocol);
        try {
            tempStream.writeTo(streamToWriteTo);
        }
        catch (IOException iOException) {}
    }

    private void writeIteratableBlockToStream(ByteArrayOutputStream streamToWriteTo, IteratableBlockDataBean messageDataDef, ProtocolMessage message) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException {
        String iterateOnField = messageDataDef.getIterateOnField();
        String iteratableBlockId = messageDataDef.getId();
        Object fieldValue = message.getFieldValue(iterateOnField);
        if (fieldValue instanceof Integer) {
            int numberOfIterations = (Integer)fieldValue;
            Collection<IMsgDataBean> internalBeans = messageDataDef.getDataBeans();
            int i = 0;
            while (i < numberOfIterations) {
                for (IMsgDataBean internalBean : internalBeans) {
                    this.writeFilterMessageDef(internalBean, streamToWriteTo, message, iteratableBlockId, i);
                }
                ++i;
            }
        } else {
            throw new InvalidMessageException("Iterate on field value is not numeric");
        }
    }

    private void writeNumberToStream(ByteArrayOutputStream streamToWriteTo, Number data, int numberOfBytes, boolean isSigned) {
        int i;
        byte[] bytesToWrite = this.getUnsignedBytes(data, numberOfBytes);
        if (isSigned && data.longValue() < 0L) {
            i = 0;
            while (i < numberOfBytes) {
                bytesToWrite[i] = (byte)(bytesToWrite[i] ^ bytesToWrite[i]);
                ++i;
            }
            bytesToWrite[numberOfBytes - 1] = (byte)(bytesToWrite[numberOfBytes - 1] + 1);
        }
        if (this.isBigEndianProtocol) {
            i = 0;
            while (i < numberOfBytes) {
                streamToWriteTo.write(bytesToWrite[i]);
                ++i;
            }
        } else {
            i = numberOfBytes - 1;
            while (i >= 0) {
                streamToWriteTo.write(bytesToWrite[i]);
                --i;
            }
        }
    }

    private void readReceivedMessage(long code, ProtocolMsgDefinition messageDef) throws ProtocolRawHandlingException, InvalidDefinitionException, InvalidInputStreamDataException, InvalidMessageException, MessageHandleException, IOException {
        if (this.isIncomingMessage(messageDef.getId())) {
            IMessageHandler handler = messageDef.getHandler();
            ProtocolMessage message = new ProtocolMessage(code);
            List<IMsgDataBean> messageDataDefList = messageDef.getMessageData();
            for (IMsgDataBean messageDataDef : messageDataDefList) {
                this.readFilterMessageDef(messageDataDef, message, null, -1);
            }
            ProtocolMessage returnedMessage = handler.handleMessage(this.handle, message);
            if (returnedMessage != null) {
                this.sendMessage(returnedMessage);
            }
        }
    }

    private void readFilterMessageDef(IMsgDataBean messageDataDef, ProtocolMessage message, String iterableBlockId, int index) throws ProtocolRawHandlingException, InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        if (messageDataDef instanceof FixedSizeDataBean) {
            this.readFixedSizeData((FixedSizeDataBean)messageDataDef, message, iterableBlockId, index);
            FixedSizeDataBean fixedMsgDataDef = (FixedSizeDataBean)messageDataDef;
            message.setFieldSize(fixedMsgDataDef.getFieldName(), iterableBlockId, index, fixedMsgDataDef.getFieldSizeInBytes());
        } else if (messageDataDef instanceof VariableSizeDataBean) {
            this.readVariableSizeData((VariableSizeDataBean)messageDataDef, message, iterableBlockId, index);
            VariableSizeDataBean variableMsgDataDef = (VariableSizeDataBean)messageDataDef;
            message.setFieldSize(variableMsgDataDef.getSizeFieldName(), iterableBlockId, index, variableMsgDataDef.getSizeFieldSizeInBytes());
        } else if (messageDataDef instanceof RawDataBean) {
            this.readRawData((RawDataBean)messageDataDef, message, iterableBlockId, index);
        } else {
            this.readIteratableBlock((IteratableBlockDataBean)messageDataDef, message);
        }
    }

    private void readFixedSizeData(FixedSizeDataBean messageDataDef, ProtocolMessage message, String iterableBlockId, int index) throws InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        String fieldName = messageDataDef.getFieldName();
        boolean isSigned = messageDataDef.isFieldSigned();
        int fieldSize = messageDataDef.getFieldSizeInBytes();
        if (fieldName != null) {
            Number value = this.getNumberDataFromInputStream(fieldSize, isSigned);
            if (value != null) {
                message.setFieldValue(fieldName, iterableBlockId, index, value);
            }
        } else {
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
    }

    private void readVariableSizeData(VariableSizeDataBean messageDataDef, ProtocolMessage message, String iterableBlockId, int index) throws InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        String sizeFieldName = messageDataDef.getSizeFieldName();
        boolean isSizeSigned = messageDataDef.isSizeFieldSigned();
        int sizeFieldSize = messageDataDef.getSizeFieldSizeInBytes();
        String valueFieldName = messageDataDef.getValueFieldName();
        String charsetName = messageDataDef.getCharsetName();
        if (valueFieldName != null) {
            Number size = this.getNumberDataFromInputStream(sizeFieldSize, isSizeSigned);
            byte[] valueArray = new byte[size.intValue()];
            int readBytes = 0;
            int remainingBytes = valueArray.length;
            while (remainingBytes > 0) {
                int tempReadBytes = -1;
                try {
                    tempReadBytes = this.in.read(valueArray, readBytes, remainingBytes);
                }
                catch (IOException e) {
                    this.handleIOExceptionOnStream();
                    throw e;
                }
                readBytes += tempReadBytes;
                remainingBytes -= tempReadBytes;
            }
            String value = new String(valueArray, charsetName);
            message.setFieldValue(valueFieldName, iterableBlockId, index, value);
            if (sizeFieldName != null && !sizeFieldName.equals("")) {
                message.setFieldValue(sizeFieldName, iterableBlockId, index, new Integer(sizeFieldSize).toString());
            }
        } else {
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
    }

    private void readRawData(RawDataBean messageDataDef, ProtocolMessage message, String iterableBlockId, int index) throws ProtocolRawHandlingException, IOException {
        ProtocolInputStream delegatableStream = new ProtocolInputStream();
        IRawDataHandler handler = messageDataDef.getHandler();
        MessageFieldsStore currentlyReadFields = new MessageFieldsStore(message, iterableBlockId, index);
        Map<String, Object> returnedFields = null;
        try {
            returnedFields = handler.readRawDataFromStream(this.handle, delegatableStream, currentlyReadFields, this.isBigEndianProtocol);
            for (String fieldName : returnedFields.keySet()) {
                Object fieldValue = returnedFields.get(fieldName);
                message.setFieldValue(fieldName, iterableBlockId, index, fieldValue);
            }
        }
        catch (IOException e) {
            this.handleIOExceptionOnStream();
            throw e;
        }
    }

    private void readIteratableBlock(IteratableBlockDataBean messageDataDef, ProtocolMessage message) throws ProtocolRawHandlingException, InvalidDefinitionException, InvalidInputStreamDataException, IOException {
        String iterateOnField = messageDataDef.getIterateOnField();
        String iteratableBlockId = messageDataDef.getId();
        Object valueObj = message.getFieldValue(iterateOnField);
        if (valueObj instanceof Integer) {
            int numberOfIterations = (Integer)valueObj;
            Collection<IMsgDataBean> internalMsgDefs = messageDataDef.getDataBeans();
            int i = 0;
            while (i < numberOfIterations) {
                for (IMsgDataBean internalMsgDef : internalMsgDefs) {
                    this.readFilterMessageDef(internalMsgDef, message, iteratableBlockId, i);
                }
                ++i;
            }
        } else {
            throw new InvalidInputStreamDataException("Iterate on field value is not numeric");
        }
    }

    private Number getNumberDataFromInputStream(int numberOfBytes, boolean isSigned) throws InvalidInputStreamDataException, IOException {
        Number value = null;
        try {
            switch (numberOfBytes) {
                case 1: {
                    value = isSigned ? (Number)this.in.readByte() : (Number)this.in.readUnsignedByte();
                    break;
                }
                case 2: {
                    value = isSigned ? (Number)this.in.readShort() : (Number)this.in.readUnsignedShort();
                    break;
                }
                case 3: {
                    if (isSigned) {
                        long tmpval = this.in.readByte();
                        tmpval <<= 8;
                        value = tmpval += (long)this.in.readShort();
                    } else {
                        long tmpval = this.in.readUnsignedByte();
                        tmpval <<= 8;
                        value = tmpval += (long)this.in.readUnsignedShort();
                    }
                    break;
                }
                case 4: {
                    value = this.in.readInt();
                    break;
                }
                case 8: {
                    value = this.in.readLong();
                    break;
                }
                default: {
                    throw new InvalidInputStreamDataException("Unrecognized field size");
                }
            }
        }
        catch (IOException e) {
            this.handleIOExceptionOnStream();
            throw e;
        }
        return value;
    }

    private byte[] getUnsignedBytes(Number number, int numberOfBytes) {
        long dataTmp = Math.abs(number.longValue());
        byte[] bytes = new byte[numberOfBytes];
        int i = 0;
        while (i < numberOfBytes) {
            byte oneByte = (byte)(dataTmp & 0xFFL);
            dataTmp >>= 8;
            bytes[numberOfBytes - i - 1] = oneByte;
            ++i;
        }
        return bytes;
    }

    private boolean isOutgoingMessage(String messageId) {
        boolean isOutgoingMessage = false;
        if (this.outgoingMessages.contains(messageId) && !this.incomingMessages.contains(messageId)) {
            isOutgoingMessage = true;
        }
        return isOutgoingMessage;
    }

    private boolean isIncomingMessage(String messageId) {
        boolean isIncomingMessage = false;
        if (this.incomingMessages.contains(messageId) && !this.outgoingMessages.contains(messageId)) {
            isIncomingMessage = true;
        }
        return isIncomingMessage;
    }

    private void handleIOExceptionOnStream() {
        if (this.isConnected()) {
            try {
                this.stopProtocol();
            }
            catch (IOException iOException) {}
        }
        IModel model = ClientModel.getInstance();
        model.cleanStoppedProtocols();
        model = ServerModel.getInstance();
        model.cleanStoppedProtocols();
    }

    private class Consumer
    implements Runnable {
        private boolean isRunning = true;

        private Consumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long code = 0L;
            while (this.isRunning) {
                try {
                    if (code > 0x3FFFFFFFFFFFFFFFL) {
                        System.out.println("Message not found. Stopping protocol...");
                        ProtocolEngine.this.stopProtocol();
                        continue;
                    }
                    int nextByte = ProtocolEngine.this.in.read();
                    code <<= 8;
                    ProtocolMsgDefinition messageDef = (ProtocolMsgDefinition)ProtocolEngine.this.messageDefCollection.get(-(code += (long)nextByte));
                    if (messageDef == null) continue;
                    Socket socket = ProtocolEngine.this.socket;
                    synchronized (socket) {
                        ProtocolEngine.this.readReceivedMessage(-code, messageDef);
                    }
                    code = 0L;
                }
                catch (IOException e) {
                    if (!this.isRunning) continue;
                    this.isRunning = false;
                    if (ProtocolEngine.this.exceptionHandler == null) continue;
                    ProtocolEngine.this.exceptionHandler.handleIOException(ProtocolEngine.this.handle, e);
                }
                catch (Exception e) {
                    this.isRunning = false;
                    if (ProtocolEngine.this.exceptionHandler == null) continue;
                    if (e instanceof ProtocolInitException) {
                        ProtocolEngine.this.exceptionHandler.handleProtocolInitException(ProtocolEngine.this.handle, (ProtocolInitException)e);
                        continue;
                    }
                    if (e instanceof MessageHandleException) {
                        ProtocolEngine.this.exceptionHandler.handleMessageHandleException(ProtocolEngine.this.handle, (MessageHandleException)e);
                        continue;
                    }
                    if (e instanceof InvalidMessageException) {
                        ProtocolEngine.this.exceptionHandler.handleInvalidMessageException(ProtocolEngine.this.handle, (InvalidMessageException)e);
                        continue;
                    }
                    if (e instanceof InvalidInputStreamDataException) {
                        ProtocolEngine.this.exceptionHandler.handleInvalidInputStreamDataException(ProtocolEngine.this.handle, (InvalidInputStreamDataException)e);
                        continue;
                    }
                    if (e instanceof InvalidDefinitionException) {
                        ProtocolEngine.this.exceptionHandler.handleInvalidDefinitionException(ProtocolEngine.this.handle, (InvalidDefinitionException)e);
                        continue;
                    }
                    if (!(e instanceof ProtocolRawHandlingException)) continue;
                    ProtocolEngine.this.exceptionHandler.handleProtocolRawHandlingException(ProtocolEngine.this.handle, (ProtocolRawHandlingException)e);
                }
            }
        }

        public void stopConsumer() {
            this.isRunning = false;
        }
    }

    private class ProtocolInputStream
    extends InputStream {
        private ProtocolInputStream() {
        }

        public int read() throws IOException {
            return ProtocolEngine.this.in.read();
        }

        public int read(byte[] b) throws IOException {
            return ProtocolEngine.this.in.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return ProtocolEngine.this.in.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return ProtocolEngine.this.in.skip(n);
        }

        public int available() throws IOException {
            return ProtocolEngine.this.in.available();
        }

        public void close() throws IOException {
        }

        public synchronized void mark(int readlimit) {
        }

        public synchronized void reset() throws IOException {
        }

        public boolean markSupported() {
            return false;
        }
    }
}

